from pyspark.sql.types import ArrayType, StringType, StructField, StructType

from spark_fhir_schemas.r4.complex_types.id import id
from spark_fhir_schemas.r4.complex_types.meta import Meta
from spark_fhir_schemas.r4.complex_types.uri import uri
from spark_fhir_schemas.r4.complex_types.code import code
from spark_fhir_schemas.r4.complex_types.narrative import Narrative
from spark_fhir_schemas.r4.complex_types.resourcelist import ResourceList
from spark_fhir_schemas.r4.complex_types.extension import Extension
from spark_fhir_schemas.r4.complex_types.identifier import Identifier
from spark_fhir_schemas.r4.complex_types.codeableconcept import CodeableConcept
from spark_fhir_schemas.r4.complex_types.reference import Reference
from spark_fhir_schemas.r4.complex_types.period import Period
from spark_fhir_schemas.r4.complex_types.datetime import dateTime
from spark_fhir_schemas.r4.complex_types.clinicalimpression_investigation import ClinicalImpression_Investigation
from spark_fhir_schemas.r4.complex_types.clinicalimpression_finding import ClinicalImpression_Finding
from spark_fhir_schemas.r4.complex_types.annotation import Annotation


# noinspection PyPep8Naming
class ClinicalImpression:
    @staticmethod
    def get_schema() -> StructType:
        # from https://hl7.org/FHIR/patient.html
        schema = StructType(
            [
                StructField("resourceType", StringType(), True),
                StructField("id", id.get_schema(), True),
                StructField("meta", Meta.get_schema(), True),
                StructField("implicitRules", uri.get_schema(), True),
                StructField("language", code.get_schema(), True),
                StructField("text", Narrative.get_schema(), True),
                StructField(
                    "contained", ArrayType(ResourceList.get_schema()), True
                ),
                StructField(
                    "extension", ArrayType(Extension.get_schema()), True
                ),
                StructField(
                    "modifierExtension", ArrayType(Extension.get_schema()),
                    True
                ),
                StructField(
                    "identifier", ArrayType(Identifier.get_schema()), True
                ),
                StructField("status", code.get_schema(), True),
                StructField(
                    "statusReason", CodeableConcept.get_schema(), True
                ),
                StructField("code", CodeableConcept.get_schema(), True),
                StructField("description", StringType(), True),
                StructField("subject", Reference.get_schema(), True),
                StructField("encounter", Reference.get_schema(), True),
                StructField("effectiveDateTime", StringType(), True),
                StructField("effectivePeriod", Period.get_schema(), True),
                StructField("date", dateTime.get_schema(), True),
                StructField("assessor", Reference.get_schema(), True),
                StructField("previous", Reference.get_schema(), True),
                StructField(
                    "problem", ArrayType(Reference.get_schema()), True
                ),
                StructField(
                    "investigation",
                    ArrayType(ClinicalImpression_Investigation.get_schema()),
                    True
                ),
                StructField("protocol", ArrayType(uri.get_schema()), True),
                StructField("summary", StringType(), True),
                StructField(
                    "finding",
                    ArrayType(ClinicalImpression_Finding.get_schema()), True
                ),
                StructField(
                    "prognosisCodeableConcept",
                    ArrayType(CodeableConcept.get_schema()), True
                ),
                StructField(
                    "prognosisReference", ArrayType(Reference.get_schema()),
                    True
                ),
                StructField(
                    "supportingInfo", ArrayType(Reference.get_schema()), True
                ),
                StructField("note", ArrayType(Annotation.get_schema()), True),
            ]
        )

        return schema
