from pyspark.sql.types import ArrayType, StringType, StructField, StructType

from spark_fhir_schemas.r4.complex_types.extension import Extension
from spark_fhir_schemas.r4.complex_types.id import id
from spark_fhir_schemas.r4.complex_types.uri import uri


# noinspection PyPep8Naming
class StructureDefinition_Mapping:
    @staticmethod
    def get_schema() -> StructType:
        # from https://hl7.org/FHIR/patient.html
        schema = StructType(
            [
                StructField("id", StringType(), True),
                StructField(
                    "extension", ArrayType(Extension.get_schema()), True
                ),
                StructField(
                    "modifierExtension", ArrayType(Extension.get_schema()),
                    True
                ),
                StructField("identity", id.get_schema(), True),
                StructField("uri", uri.get_schema(), True),
                StructField("name", StringType(), True),
                StructField("comment", StringType(), True),
            ]
        )

        return schema
