from pyspark.sql.types import ArrayType, StringType, StructField, StructType

from spark_fhir_schemas.r4.complex_types.extension import Extension
from spark_fhir_schemas.r4.complex_types.uri import uri
from spark_fhir_schemas.r4.complex_types.identifier import Identifier


# noinspection PyPep8Naming
class Reference:
    @staticmethod
    def get_schema() -> StructType:
        # from https://hl7.org/FHIR/patient.html
        schema = StructType(
            [
                StructField("id", StringType(), True),
                StructField(
                    "extension", ArrayType(Extension.get_schema()), True
                ),
                StructField("reference", StringType(), True),
                StructField("type", uri.get_schema(), True),
                StructField("identifier", Identifier.get_schema(), True),
                StructField("display", StringType(), True),
            ]
        )

        return schema
