from pyspark.sql.types import ArrayType, DateType, StringType, StructField, StructType

from spark_fhir_schemas.r4.complex_types.extension import Extension
from spark_fhir_schemas.r4.complex_types.identifier import Identifier
from spark_fhir_schemas.r4.complex_types.codeableconcept import CodeableConcept
from spark_fhir_schemas.r4.complex_types.reference import Reference
from spark_fhir_schemas.r4.complex_types.money import Money


# noinspection PyPep8Naming
class PaymentReconciliation_Detail:
    @staticmethod
    def get_schema() -> StructType:
        # from https://hl7.org/FHIR/patient.html
        schema = StructType(
            [
                StructField("id", StringType(), True),
                StructField(
                    "extension", ArrayType(Extension.get_schema()), True
                ),
                StructField(
                    "modifierExtension", ArrayType(Extension.get_schema()),
                    True
                ),
                StructField("identifier", Identifier.get_schema(), True),
                StructField("predecessor", Identifier.get_schema(), True),
                StructField("type", CodeableConcept.get_schema(), True),
                StructField("request", Reference.get_schema(), True),
                StructField("submitter", Reference.get_schema(), True),
                StructField("response", Reference.get_schema(), True),
                StructField("date", DateType(), True),
                StructField("responsible", Reference.get_schema(), True),
                StructField("payee", Reference.get_schema(), True),
                StructField("amount", Money.get_schema(), True),
            ]
        )

        return schema
