from pyspark.sql.types import ArrayType, StringType, StructField, StructType

from spark_fhir_schemas.r4.complex_types.extension import Extension
from spark_fhir_schemas.r4.complex_types.identifier import Identifier
from spark_fhir_schemas.r4.complex_types.codeableconcept import CodeableConcept
from spark_fhir_schemas.r4.complex_types.reference import Reference
from spark_fhir_schemas.r4.complex_types.datetime import dateTime


# noinspection PyPep8Naming
class MedicinalProduct_SpecialDesignation:
    @staticmethod
    def get_schema() -> StructType:
        # from https://hl7.org/FHIR/patient.html
        schema = StructType(
            [
                StructField("id", StringType(), True),
                StructField(
                    "extension", ArrayType(Extension.get_schema()), True
                ),
                StructField(
                    "modifierExtension", ArrayType(Extension.get_schema()),
                    True
                ),
                StructField(
                    "identifier", ArrayType(Identifier.get_schema()), True
                ),
                StructField("type", CodeableConcept.get_schema(), True),
                StructField("intendedUse", CodeableConcept.get_schema(), True),
                StructField(
                    "indicationCodeableConcept", CodeableConcept.get_schema(),
                    True
                ),
                StructField(
                    "indicationReference", Reference.get_schema(), True
                ),
                StructField("status", CodeableConcept.get_schema(), True),
                StructField("date", dateTime.get_schema(), True),
                StructField("species", CodeableConcept.get_schema(), True),
            ]
        )

        return schema
