from pyspark.sql.types import ArrayType, StringType, StructField, StructType

from spark_fhir_schemas.r4.complex_types.extension import Extension
from spark_fhir_schemas.r4.complex_types.decimal import decimal


# noinspection PyPep8Naming
class Location_Position:
    @staticmethod
    def get_schema() -> StructType:
        # from https://hl7.org/FHIR/patient.html
        schema = StructType(
            [
                StructField("id", StringType(), True),
                StructField(
                    "extension", ArrayType(Extension.get_schema()), True
                ),
                StructField(
                    "modifierExtension", ArrayType(Extension.get_schema()),
                    True
                ),
                StructField("longitude", decimal.get_schema(), True),
                StructField("latitude", decimal.get_schema(), True),
                StructField("altitude", decimal.get_schema(), True),
            ]
        )

        return schema
