from pyspark.sql.types import ArrayType, StringType, StructField, StructType

from spark_fhir_schemas.r4.complex_types.extension import Extension
from spark_fhir_schemas.r4.complex_types.codeableconcept import CodeableConcept
from spark_fhir_schemas.r4.complex_types.reference import Reference
from spark_fhir_schemas.r4.complex_types.insuranceplan_benefit import InsurancePlan_Benefit


# noinspection PyPep8Naming
class InsurancePlan_Coverage:
    @staticmethod
    def get_schema() -> StructType:
        # from https://hl7.org/FHIR/patient.html
        schema = StructType(
            [
                StructField("id", StringType(), True),
                StructField(
                    "extension", ArrayType(Extension.get_schema()), True
                ),
                StructField(
                    "modifierExtension", ArrayType(Extension.get_schema()),
                    True
                ),
                StructField("type", CodeableConcept.get_schema(), True),
                StructField(
                    "network", ArrayType(Reference.get_schema()), True
                ),
                StructField(
                    "benefit", ArrayType(InsurancePlan_Benefit.get_schema()),
                    True
                ),
            ]
        )

        return schema
