from pyspark.sql.types import ArrayType, StringType, StructField, StructType

from spark_fhir_schemas.r4.complex_types.extension import Extension
from spark_fhir_schemas.r4.complex_types.code import code


# noinspection PyPep8Naming
class GraphDefinition_Compartment:
    @staticmethod
    def get_schema() -> StructType:
        # from https://hl7.org/FHIR/patient.html
        schema = StructType(
            [
                StructField("id", StringType(), True),
                StructField(
                    "extension", ArrayType(Extension.get_schema()), True
                ),
                StructField(
                    "modifierExtension", ArrayType(Extension.get_schema()),
                    True
                ),
                StructField("use", StringType(), True),
                StructField("code", code.get_schema(), True),
                StructField("rule", StringType(), True),
                StructField("expression", StringType(), True),
                StructField("description", StringType(), True),
            ]
        )

        return schema
