from pyspark.sql.types import ArrayType, StringType, StructField, StructType

from spark_fhir_schemas.r4.complex_types.extension import Extension
from spark_fhir_schemas.r4.complex_types.positiveint import positiveInt
from spark_fhir_schemas.r4.complex_types.codeableconcept import CodeableConcept
from spark_fhir_schemas.r4.complex_types.reference import Reference


# noinspection PyPep8Naming
class ExplanationOfBenefit_Diagnosis:
    @staticmethod
    def get_schema() -> StructType:
        # from https://hl7.org/FHIR/patient.html
        schema = StructType(
            [
                StructField("id", StringType(), True),
                StructField(
                    "extension", ArrayType(Extension.get_schema()), True
                ),
                StructField(
                    "modifierExtension", ArrayType(Extension.get_schema()),
                    True
                ),
                StructField("sequence", positiveInt.get_schema(), True),
                StructField(
                    "diagnosisCodeableConcept", CodeableConcept.get_schema(),
                    True
                ),
                StructField(
                    "diagnosisReference", Reference.get_schema(), True
                ),
                StructField(
                    "type", ArrayType(CodeableConcept.get_schema()), True
                ),
                StructField("onAdmission", CodeableConcept.get_schema(), True),
                StructField("packageCode", CodeableConcept.get_schema(), True),
            ]
        )

        return schema
