from pyspark.sql.types import ArrayType, StringType, StructField, StructType

from spark_fhir_schemas.r4.complex_types.extension import Extension
from spark_fhir_schemas.r4.complex_types.reference import Reference
from spark_fhir_schemas.r4.complex_types.period import Period


# noinspection PyPep8Naming
class BiologicallyDerivedProduct_Collection:
    @staticmethod
    def get_schema() -> StructType:
        # from https://hl7.org/FHIR/patient.html
        schema = StructType(
            [
                StructField("id", StringType(), True),
                StructField(
                    "extension", ArrayType(Extension.get_schema()), True
                ),
                StructField(
                    "modifierExtension", ArrayType(Extension.get_schema()),
                    True
                ),
                StructField("collector", Reference.get_schema(), True),
                StructField("source", Reference.get_schema(), True),
                StructField("collectedDateTime", StringType(), True),
                StructField("collectedPeriod", Period.get_schema(), True),
            ]
        )

        return schema
