from pyspark.sql.types import ArrayType, StringType, StructField, StructType

from spark_fhir_schemas.r4.complex_types.extension import Extension
from spark_fhir_schemas.r4.complex_types.reference import Reference
from spark_fhir_schemas.r4.complex_types.adverseevent_causality import AdverseEvent_Causality


# noinspection PyPep8Naming
class AdverseEvent_SuspectEntity:
    @staticmethod
    def get_schema() -> StructType:
        # from https://hl7.org/FHIR/patient.html
        schema = StructType(
            [
                StructField("id", StringType(), True),
                StructField(
                    "extension", ArrayType(Extension.get_schema()), True
                ),
                StructField(
                    "modifierExtension", ArrayType(Extension.get_schema()),
                    True
                ),
                StructField("instance", Reference.get_schema(), True),
                StructField(
                    "causality",
                    ArrayType(AdverseEvent_Causality.get_schema()), True
                ),
            ]
        )

        return schema
