# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['ResourceActionArgs', 'ResourceAction']

@pulumi.input_type
class ResourceActionArgs:
    def __init__(__self__, *,
                 resource_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 action: Optional[pulumi.Input[str]] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 response_export_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a ResourceAction resource.
        :param pulumi.Input[str] resource_id: The ID of an existing azure source.
        :param pulumi.Input[str] type: It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
               `<api-version>` is version of the API used to manage this azure resource.
        :param pulumi.Input[str] action: The name of the resource action. It's also possible to make Http requests towards the resource ID if leave this field empty.
        :param pulumi.Input[str] body: A JSON object that contains the request body.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locks: A list of ARM resource IDs which are used to avoid modify azapi resources at the same time.
        :param pulumi.Input[str] method: Specifies the Http method of the azure resource action. Allowed values are `POST`, `PATCH`, `PUT` and `DELETE`. Defaults to `POST`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_export_values: A list of path that needs to be exported from response body.
               Setting it to `["*"]` will export the full response body.
               Here's an example. If it sets to `["keys"]`, it will set the following json to computed property `output`.
               ```python
               import pulumi
               ```
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "type", type)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if response_export_values is not None:
            pulumi.set(__self__, "response_export_values", response_export_values)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The ID of an existing azure source.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
        `<api-version>` is version of the API used to manage this azure resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource action. It's also possible to make Http requests towards the resource ID if leave this field empty.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON object that contains the request body.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of ARM resource IDs which are used to avoid modify azapi resources at the same time.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Http method of the azure resource action. Allowed values are `POST`, `PATCH`, `PUT` and `DELETE`. Defaults to `POST`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter(name="responseExportValues")
    def response_export_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of path that needs to be exported from response body.
        Setting it to `["*"]` will export the full response body.
        Here's an example. If it sets to `["keys"]`, it will set the following json to computed property `output`.
        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "response_export_values")

    @response_export_values.setter
    def response_export_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "response_export_values", value)


@pulumi.input_type
class _ResourceActionState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 output: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 response_export_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ResourceAction resources.
        :param pulumi.Input[str] action: The name of the resource action. It's also possible to make Http requests towards the resource ID if leave this field empty.
        :param pulumi.Input[str] body: A JSON object that contains the request body.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locks: A list of ARM resource IDs which are used to avoid modify azapi resources at the same time.
        :param pulumi.Input[str] method: Specifies the Http method of the azure resource action. Allowed values are `POST`, `PATCH`, `PUT` and `DELETE`. Defaults to `POST`.
        :param pulumi.Input[str] output: The output json containing the properties specified in `response_export_values`. Here are some examples to decode json and extract the value.
        :param pulumi.Input[str] resource_id: The ID of an existing azure source.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_export_values: A list of path that needs to be exported from response body.
               Setting it to `["*"]` will export the full response body.
               Here's an example. If it sets to `["keys"]`, it will set the following json to computed property `output`.
               ```python
               import pulumi
               ```
        :param pulumi.Input[str] type: It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
               `<api-version>` is version of the API used to manage this azure resource.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if output is not None:
            pulumi.set(__self__, "output", output)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if response_export_values is not None:
            pulumi.set(__self__, "response_export_values", response_export_values)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the resource action. It's also possible to make Http requests towards the resource ID if leave this field empty.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        A JSON object that contains the request body.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of ARM resource IDs which are used to avoid modify azapi resources at the same time.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter
    def method(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Http method of the azure resource action. Allowed values are `POST`, `PATCH`, `PUT` and `DELETE`. Defaults to `POST`.
        """
        return pulumi.get(self, "method")

    @method.setter
    def method(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method", value)

    @property
    @pulumi.getter
    def output(self) -> Optional[pulumi.Input[str]]:
        """
        The output json containing the properties specified in `response_export_values`. Here are some examples to decode json and extract the value.
        """
        return pulumi.get(self, "output")

    @output.setter
    def output(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "output", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of an existing azure source.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="responseExportValues")
    def response_export_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of path that needs to be exported from response body.
        Setting it to `["*"]` will export the full response body.
        Here's an example. If it sets to `["keys"]`, it will set the following json to computed property `output`.
        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "response_export_values")

    @response_export_values.setter
    def response_export_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "response_export_values", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
        `<api-version>` is version of the API used to manage this azure resource.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class ResourceAction(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 response_export_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource can perform any Azure resource manager resource action.
        It's recommended to use `ResourceAction` resource to perform actions which change a resource's state, please use `ResourceAction` data source,
        if user wants to perform readonly action.

        > **Note** When delete `ResourceAction`, no operation will be performed.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The name of the resource action. It's also possible to make Http requests towards the resource ID if leave this field empty.
        :param pulumi.Input[str] body: A JSON object that contains the request body.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locks: A list of ARM resource IDs which are used to avoid modify azapi resources at the same time.
        :param pulumi.Input[str] method: Specifies the Http method of the azure resource action. Allowed values are `POST`, `PATCH`, `PUT` and `DELETE`. Defaults to `POST`.
        :param pulumi.Input[str] resource_id: The ID of an existing azure source.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_export_values: A list of path that needs to be exported from response body.
               Setting it to `["*"]` will export the full response body.
               Here's an example. If it sets to `["keys"]`, it will set the following json to computed property `output`.
               ```python
               import pulumi
               ```
        :param pulumi.Input[str] type: It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
               `<api-version>` is version of the API used to manage this azure resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ResourceActionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource can perform any Azure resource manager resource action.
        It's recommended to use `ResourceAction` resource to perform actions which change a resource's state, please use `ResourceAction` data source,
        if user wants to perform readonly action.

        > **Note** When delete `ResourceAction`, no operation will be performed.

        :param str resource_name: The name of the resource.
        :param ResourceActionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ResourceActionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 method: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 response_export_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ResourceActionArgs.__new__(ResourceActionArgs)

            __props__.__dict__["action"] = action
            __props__.__dict__["body"] = body
            __props__.__dict__["locks"] = locks
            __props__.__dict__["method"] = method
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            __props__.__dict__["response_export_values"] = response_export_values
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["output"] = None
        super(ResourceAction, __self__).__init__(
            'azapi:index/resourceAction:ResourceAction',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            body: Optional[pulumi.Input[str]] = None,
            locks: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            method: Optional[pulumi.Input[str]] = None,
            output: Optional[pulumi.Input[str]] = None,
            resource_id: Optional[pulumi.Input[str]] = None,
            response_export_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'ResourceAction':
        """
        Get an existing ResourceAction resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The name of the resource action. It's also possible to make Http requests towards the resource ID if leave this field empty.
        :param pulumi.Input[str] body: A JSON object that contains the request body.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] locks: A list of ARM resource IDs which are used to avoid modify azapi resources at the same time.
        :param pulumi.Input[str] method: Specifies the Http method of the azure resource action. Allowed values are `POST`, `PATCH`, `PUT` and `DELETE`. Defaults to `POST`.
        :param pulumi.Input[str] output: The output json containing the properties specified in `response_export_values`. Here are some examples to decode json and extract the value.
        :param pulumi.Input[str] resource_id: The ID of an existing azure source.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] response_export_values: A list of path that needs to be exported from response body.
               Setting it to `["*"]` will export the full response body.
               Here's an example. If it sets to `["keys"]`, it will set the following json to computed property `output`.
               ```python
               import pulumi
               ```
        :param pulumi.Input[str] type: It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
               `<api-version>` is version of the API used to manage this azure resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ResourceActionState.__new__(_ResourceActionState)

        __props__.__dict__["action"] = action
        __props__.__dict__["body"] = body
        __props__.__dict__["locks"] = locks
        __props__.__dict__["method"] = method
        __props__.__dict__["output"] = output
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["response_export_values"] = response_export_values
        __props__.__dict__["type"] = type
        return ResourceAction(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the resource action. It's also possible to make Http requests towards the resource ID if leave this field empty.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def body(self) -> pulumi.Output[Optional[str]]:
        """
        A JSON object that contains the request body.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter
    def locks(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of ARM resource IDs which are used to avoid modify azapi resources at the same time.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter
    def method(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the Http method of the azure resource action. Allowed values are `POST`, `PATCH`, `PUT` and `DELETE`. Defaults to `POST`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def output(self) -> pulumi.Output[str]:
        """
        The output json containing the properties specified in `response_export_values`. Here are some examples to decode json and extract the value.
        """
        return pulumi.get(self, "output")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[str]:
        """
        The ID of an existing azure source.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="responseExportValues")
    def response_export_values(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of path that needs to be exported from response body.
        Setting it to `["*"]` will export the full response body.
        Here's an example. If it sets to `["keys"]`, it will set the following json to computed property `output`.
        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "response_export_values")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        It is in a format like `<resource-type>@<api-version>`. `<resource-type>` is the Azure resource type, for example, `Microsoft.Storage/storageAccounts`.
        `<api-version>` is version of the API used to manage this azure resource.
        """
        return pulumi.get(self, "type")

