forensicface
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

## Install

``` sh
pip install forensicface
```

Os arquivos onnx dos modelos de detecção (det_10g.onnx), pose
(1k3d68.onnx) e gênero/idade (genderage.onnx) devem estar na pasta
`~/.insightface/model/sepaelv2/`

O arquivo onnx do modelo de reconhecimento (adaface_ir101web12m.onnx)
deve estar na pasta `~/.insightface/model/sepaelv2/adaface/`

O arquivo onnx do modelo magface (magface_iresnet100.onnx) deve estar na
pasta `~/.insightface/model/sepaelv2/magface/`

## Como utilizar

Importação da classe ForensicFace:

`from forensicface.app import ForensicFace`

``` python
ff = ForensicFace(det_size=320, use_gpu=True)
```

## Processamento básico de imagens

Obter pontos de referência, distância interpupilar, representação
vetorial e a face alinhada com dimensão fixa (112x112)

``` python
results = ff.process_image("obama.png")
results.keys()
```

    dict_keys(['keypoints', 'ipd', 'gender', 'age', 'pitch', 'yaw', 'roll', 'embedding', 'norm', 'magface_embedding', 'magface_norm', 'aligned_face'])

Comparar duas imagens faciais e obter o escore de similaridade.

``` python
ff.compare("obama.png","obama2.png")
```

    0.8555868

Agregar embeddings de duas imagens faciais em uma única representação

``` python
agg = ff.aggregate_from_images(["obama.png","obama2.png"])
agg.shape
```

    (512,)

## Suporte a MagFace

Estimativa de qualidade pela norma da representação
[MagFace](https://github.com/IrvingMeng/MagFace)

``` python
good = ff.process_image("obama.png")
bad = ff.process_image("obama2.png")
good["magface_norm"], bad["magface_norm"]
```

    (24.875765, 21.319853)

## Crédito dos modelos utilizados

- Detecção, gênero (M/F), idade e pose (pitch, yaw, roll):
  [insightface](https://github.com/deepinsight/insightface)

- Reconhecimento: [adaface](https://github.com/mk-minchul/AdaFace) e
  [MagFace](https://github.com/IrvingMeng/MagFace)

- Estimativa de qualidade:
  [MagFace](https://github.com/IrvingMeng/MagFace)
