"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTest = exports.IntegTestCaseStack = exports.IntegTestCase = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cloud_assembly_schema_1 = require("aws-cdk-lib/cloud-assembly-schema");
const core_1 = require("aws-cdk-lib/core");
const constructs_1 = require("constructs");
const deploy_assert_1 = require("./assertions/private/deploy-assert");
const manifest_synthesizer_1 = require("./manifest-synthesizer");
const TEST_CASE_STACK_SYMBOL = Symbol.for('@aws-cdk/integ-tests.IntegTestCaseStack');
/**
 * An integration test case. Allows the definition of test properties that
 * apply to all stacks under this case.
 *
 * It is recommended that you use the IntegTest construct since that will create
 * a default IntegTestCase
 */
class IntegTestCase extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestCaseProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTestCase);
            }
            throw error;
        }
        this._assert = new deploy_assert_1.DeployAssert(this, { stack: props.assertionStack });
        this.assertions = this._assert;
    }
    /**
     * The integration test manifest for this test case. Manifests are used
     * by the integration test runner.
     */
    get manifest() {
        return {
            version: cloud_assembly_schema_1.Manifest.version(),
            testCases: { [this.node.path]: this.toTestCase(this.props) },
        };
    }
    toTestCase(props) {
        return {
            ...props,
            assertionStack: this._assert.scope.node.path,
            assertionStackName: this._assert.scope.stackName,
            stacks: props.stacks.map(s => s.node.path),
        };
    }
}
exports.IntegTestCase = IntegTestCase;
_a = JSII_RTTI_SYMBOL_1;
IntegTestCase[_a] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTestCase", version: "2.210.0-alpha.0" };
/**
 * An integration test case stack. Allows the definition of test properties
 * that should apply to this stack.
 *
 * This should be used if there are multiple stacks in the integration test
 * and it is necessary to specify different test case option for each. Otherwise
 * normal stacks should be added to IntegTest
 */
class IntegTestCaseStack extends core_1.Stack {
    /**
     * Returns whether the construct is a IntegTestCaseStack
     */
    static isIntegTestCaseStack(x) {
        return x !== null && typeof (x) === 'object' && TEST_CASE_STACK_SYMBOL in x;
    }
    constructor(scope, id, props) {
        super(scope, id, props);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestCaseStackProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTestCaseStack);
            }
            throw error;
        }
        Object.defineProperty(this, TEST_CASE_STACK_SYMBOL, { value: true });
        // TODO: should we only have a single DeployAssert per test?
        this.assertions = new deploy_assert_1.DeployAssert(this);
        this._testCase = new IntegTestCase(this, `${id}TestCase`, {
            ...props,
            stacks: [this],
        });
    }
}
exports.IntegTestCaseStack = IntegTestCaseStack;
_b = JSII_RTTI_SYMBOL_1;
IntegTestCaseStack[_b] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTestCaseStack", version: "2.210.0-alpha.0" };
/**
 * A collection of test cases. Each test case file should contain exactly one
 * instance of this class.
 */
class IntegTest extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IntegTestProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, IntegTest);
            }
            throw error;
        }
        this.enableLookups = props.enableLookups;
        const defaultTestCase = new IntegTestCase(this, 'DefaultTest', {
            stacks: props.testCases.filter(stack => !IntegTestCaseStack.isIntegTestCaseStack(stack)),
            hooks: props.hooks,
            regions: props.regions,
            diffAssets: props.diffAssets,
            allowDestroy: props.allowDestroy,
            cdkCommandOptions: props.cdkCommandOptions,
            stackUpdateWorkflow: props.stackUpdateWorkflow,
            assertionStack: props.assertionStack,
        });
        this.assertions = defaultTestCase.assertions;
        this.testCases = [
            defaultTestCase,
            ...props.testCases
                .filter(stack => IntegTestCaseStack.isIntegTestCaseStack(stack))
                .map(stack => stack._testCase),
        ];
        this.node.addValidation({
            validate: () => {
                (0, core_1.attachCustomSynthesis)(this, {
                    onSynthesize: (session) => {
                        const synthesizer = new manifest_synthesizer_1.IntegManifestSynthesizer(this.testCases, this.enableLookups);
                        synthesizer.synthesize(session);
                    },
                });
                return [];
            },
        });
    }
}
exports.IntegTest = IntegTest;
_c = JSII_RTTI_SYMBOL_1;
IntegTest[_c] = { fqn: "@aws-cdk/integ-tests-alpha.IntegTest", version: "2.210.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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