"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegManifestSynthesizer = void 0;
const cloud_assembly_schema_1 = require("aws-cdk-lib/cloud-assembly-schema");
const manifest_writer_1 = require("./manifest-writer");
const emptyManifest = {
    version: '',
    testCases: {},
};
class IntegManifestSynthesizer {
    constructor(testCases, enableLookups) {
        this.testCases = testCases;
        this.enableLookups = enableLookups;
    }
    synthesize(session) {
        const manifest = {
            enableLookups: this.enableLookups,
            ...this.testCases
                .map(tc => tc.manifest)
                .reduce(mergeManifests, emptyManifest),
        };
        const snapshotDir = session.assembly.outdir;
        manifest_writer_1.IntegManifestWriter.write(manifest, snapshotDir);
    }
}
exports.IntegManifestSynthesizer = IntegManifestSynthesizer;
function mergeManifests(m1, m2) {
    return {
        version: cloud_assembly_schema_1.Manifest.version(),
        testCases: { ...m1.testCases, ...m2.testCases },
    };
}
//# sourceMappingURL=data:application/json;base64,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