"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.deepParseJson = deepParseJson;
exports.decodeParameters = decodeParameters;
function deepParseJson(x) {
    if (typeof x === 'string') {
        return tryJsonParse(x);
    }
    if (Array.isArray(x)) {
        return x.map(deepParseJson);
    }
    if (x && typeof x === 'object') {
        for (const [key, value] of Object.entries(x)) {
            x[key] = deepParseJson(value);
        }
        return x;
    }
    return x;
}
function tryJsonParse(v) {
    if (typeof (v) !== 'string') {
        return v;
    }
    try {
        return JSON.parse(v);
    }
    catch {
        return v;
    }
}
function decodeParameters(obj) {
    return Object.fromEntries(Object.entries(obj).map(([key, value]) => {
        try {
            return [key, decodeValue(value)];
        }
        catch {
            // if the value cannot be parsed, leave it unchanged
            // this will end up as a string
            return [key, value];
        }
    }));
}
function decodeValue(value) {
    if (value != null && !Array.isArray(value) && typeof value === 'object') {
        if (value.$type === 'ArrayBufferView') {
            return new TextEncoder().encode(value.string);
        }
    }
    return JSON.parse(value);
}
//# sourceMappingURL=data:application/json;base64,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