"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsApiCallHandler = void 0;
/* eslint-disable no-console */
const base_1 = require("./base");
const aws_custom_resource_sdk_adapter_1 = require("@aws-cdk/aws-custom-resource-sdk-adapter");
const utils_1 = require("./utils");
class AwsApiCallHandler extends base_1.CustomResourceHandler {
    async processEvent(request) {
        const apiCall = new aws_custom_resource_sdk_adapter_1.ApiCall(request.service, request.api);
        const parameters = request.parameters ? (0, utils_1.decodeParameters)(request.parameters) : {};
        console.log(`SDK request to ${apiCall.service}.${apiCall.action} with parameters ${JSON.stringify(parameters)}`);
        const response = await apiCall.invoke({ parameters });
        console.log(`SDK response received ${JSON.stringify(response)}`);
        delete response.$metadata;
        let resp;
        if (request.outputPaths || request.flattenResponse === 'true') {
            // Flatten and explode JSON fields
            const flattened = (0, aws_custom_resource_sdk_adapter_1.flatten)((0, utils_1.deepParseJson)({ apiCallResponse: response }));
            resp = request.outputPaths ? filterKeys(flattened, request.outputPaths) : flattened;
        }
        else {
            // Otherwise just return the response as-is, without exploding JSON fields
            resp = { apiCallResponse: response };
        }
        console.log(`Returning result ${JSON.stringify(resp)}`);
        return resp;
    }
}
exports.AwsApiCallHandler = AwsApiCallHandler;
function filterKeys(object, searchStrings) {
    return Object.entries(object).reduce((filteredObject, [key, value]) => {
        for (const searchString of searchStrings) {
            if (key.startsWith(`apiCallResponse.${searchString}`)) {
                filteredObject[key] = value;
            }
        }
        return filteredObject;
    }, {});
}
//# sourceMappingURL=data:application/json;base64,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