"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.md5hash = md5hash;
const helpers_internal_1 = require("aws-cdk-lib/core/lib/helpers-internal");
function md5hash(obj) {
    if (!obj || (typeof (obj) === 'object' && Object.keys(obj).length === 0)) {
        throw new Error('Cannot compute md5 hash for falsy object');
    }
    return (0, helpers_internal_1.md5hash)(JSON.stringify(obj));
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGFzaC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImhhc2gudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFFQSwwQkFLQztBQVBELDRFQUEyRTtBQUUzRSxTQUFnQixPQUFPLENBQUMsR0FBUTtJQUM5QixJQUFJLENBQUMsR0FBRyxJQUFJLENBQUMsT0FBTSxDQUFDLEdBQUcsQ0FBQyxLQUFLLFFBQVEsSUFBSSxNQUFNLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxDQUFDLE1BQU0sS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDO1FBQ3hFLE1BQU0sSUFBSSxLQUFLLENBQUMsMENBQTBDLENBQUMsQ0FBQztJQUM5RCxDQUFDO0lBQ0QsT0FBTyxJQUFBLDBCQUFPLEVBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0FBQ3RDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBtZDVoYXNoIGFzIGNvcmVNZDUgfSBmcm9tICdhd3MtY2RrLWxpYi9jb3JlL2xpYi9oZWxwZXJzLWludGVybmFsJztcblxuZXhwb3J0IGZ1bmN0aW9uIG1kNWhhc2gob2JqOiBhbnkpOiBzdHJpbmcge1xuICBpZiAoIW9iaiB8fCAodHlwZW9mKG9iaikgPT09ICdvYmplY3QnICYmIE9iamVjdC5rZXlzKG9iaikubGVuZ3RoID09PSAwKSkge1xuICAgIHRocm93IG5ldyBFcnJvcignQ2Fubm90IGNvbXB1dGUgbWQ1IGhhc2ggZm9yIGZhbHN5IG9iamVjdCcpO1xuICB9XG4gIHJldHVybiBjb3JlTWQ1KEpTT04uc3RyaW5naWZ5KG9iaikpO1xufVxuIl19