"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpApiCall = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const api_call_base_1 = require("./api-call-base");
const providers_1 = require("./providers");
const waiter_state_machine_1 = require("./waiter-state-machine");
/**
 * Construct that creates a custom resource that will perform
 * an HTTP API Call
 */
class HttpApiCall extends api_call_base_1.ApiCallBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_HttpCallProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpApiCall);
            }
            throw error;
        }
        let name = '';
        if (!aws_cdk_lib_1.Token.isUnresolved(props.url)) {
            const url = new URL(props.url);
            name = `${url.hostname}${url.pathname}`.replace(/\/|\.|:/g, '');
        }
        this.provider = new providers_1.AssertionsProvider(this, 'HttpProvider');
        this.apiCallResource = new aws_cdk_lib_1.CustomResource(this, 'Default', {
            serviceToken: this.provider.serviceToken,
            properties: {
                parameters: props,
                expected: aws_cdk_lib_1.Lazy.any({ produce: () => this.expectedResult }),
                stateMachineArn: aws_cdk_lib_1.Lazy.string({ produce: () => this.stateMachineArn }),
                flattenResponse: aws_cdk_lib_1.Lazy.string({ produce: () => this.flattenResponse }),
                salt: Date.now().toString(),
            },
            resourceType: `${providers_1.HTTP_RESOURCE_TYPE}${name}`.substring(0, 60),
        });
        // Needed so that all the policies set up by the provider should be available before the custom resource is provisioned.
        this.apiCallResource.node.addDependency(this.provider);
        aws_cdk_lib_1.Aspects.of(this).add({
            visit(node) {
                if (node instanceof HttpApiCall) {
                    if (node.expectedResult) {
                        const result = node.apiCallResource.getAttString('assertion');
                        new aws_cdk_lib_1.CfnOutput(node, 'AssertionResults', {
                            value: result,
                        }).overrideLogicalId(`AssertionResults${id.replace(/[\W_]+/g, '')}`);
                    }
                }
            },
        }, { priority: aws_cdk_lib_1.AspectPriority.MUTATING });
    }
    assertAtPath(_path, _expected) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_ExpectedResult(_expected);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.assertAtPath);
            }
            throw error;
        }
        return this;
    }
    waitForAssertions(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_WaiterStateMachineOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.waitForAssertions);
            }
            throw error;
        }
        const waiter = new waiter_state_machine_1.WaiterStateMachine(this, 'WaitFor', {
            ...options,
        });
        this.stateMachineArn = waiter.stateMachineArn;
        this.provider.addPolicyStatementFromSdkCall('states', 'StartExecution');
        return this;
    }
}
exports.HttpApiCall = HttpApiCall;
_a = JSII_RTTI_SYMBOL_1;
HttpApiCall[_a] = { fqn: "@aws-cdk/integ-tests-alpha.HttpApiCall", version: "2.210.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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