"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpectedResult = exports.ActualResult = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents the "actual" results to compare
 */
class ActualResult {
    /**
     * Get the actual results from a CustomResource
     */
    static fromCustomResource(customResource, attribute) {
        return {
            result: customResource.getAttString(attribute),
        };
    }
    /**
     * Get the actual results from a AwsApiCall
     */
    static fromAwsApiCall(query, attribute) {
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_IApiCall(query);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAwsApiCall);
            }
            throw error;
        }
        return {
            result: query.getAttString(attribute),
        };
    }
}
exports.ActualResult = ActualResult;
_a = JSII_RTTI_SYMBOL_1;
ActualResult[_a] = { fqn: "@aws-cdk/integ-tests-alpha.ActualResult", version: "2.210.0-alpha.0" };
/**
 * Represents the "expected" results to compare
 */
class ExpectedResult {
    /**
     * The actual results must match exactly. Missing data
     * will result in a failure
     *
     * @example
     * // actual results
     * const actual = {
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * };
     * // pass
     * ExpectedResult.exact({
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     * })
     *
     * // fail
     * ExpectedResult.exact({
     *   stringParam: 'hello',
     * });
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.assertions.Match.html#static-exactpattern
     */
    static exact(expected) {
        return {
            result: JSON.stringify({
                $Exact: expected,
            }),
        };
    }
    /**
     * The expected results must be a subset of the
     * actual results.
     *
     * @example
     * // actual results
     * const actual = {
     *   stringParam: 'hello',
     *   numberParam: 3,
     *   booleanParam: true,
     *   objectParam: { prop1: 'value', prop2: 'value' },
     * };
     * // pass
     * ExpectedResult.objectLike({
     *   stringParam: 'hello',
     *   objectParam: { prop1: 'value' },
     * });
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.assertions.Match.html#static-objectwbrlikepattern
     */
    static objectLike(expected) {
        return {
            result: JSON.stringify({
                $ObjectLike: expected,
            }),
        };
    }
    /**
     * The actual results must be a list and must contain
     * an item with the expected results.
     *
     * @example
     * // actual results
     * const actual = [
     *   {
     *     stringParam: 'hello',
     *   },
     *   {
     *     stringParam: 'world',
     *   },
     * ];
     * // pass
     * ExpectedResult.arrayWith([
     *   {
     *     stringParam: 'hello',
     *   },
     * ]);
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.assertions.Match.html#static-arraywbrwithpattern
     */
    static arrayWith(expected) {
        return {
            result: JSON.stringify({
                $ArrayWith: expected,
            }),
        };
    }
    /**
     * Actual results is a string that matches
     * the Expected result regex
     *
     * @example
     * // actual results
     * const actual = 'some string value';
     *
     * // pass
     * ExpectedResult.stringLikeRegexp('value');
     *
     * @see https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.assertions.Match.html#static-stringwbrlikewbrregexppattern
     */
    static stringLikeRegexp(expected) {
        return {
            result: JSON.stringify({
                $StringLike: expected,
            }),
        };
    }
}
exports.ExpectedResult = ExpectedResult;
_b = JSII_RTTI_SYMBOL_1;
ExpectedResult[_b] = { fqn: "@aws-cdk/integ-tests-alpha.ExpectedResult", version: "2.210.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29tbW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY29tbW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUdBOztHQUVHO0FBQ0gsTUFBc0IsWUFBWTtJQUNoQzs7T0FFRztJQUNJLE1BQU0sQ0FBQyxrQkFBa0IsQ0FBQyxjQUE4QixFQUFFLFNBQWlCO1FBQ2hGLE9BQU87WUFDTCxNQUFNLEVBQUUsY0FBYyxDQUFDLFlBQVksQ0FBQyxTQUFTLENBQUM7U0FDL0MsQ0FBQztLQUNIO0lBRUQ7O09BRUc7SUFDSSxNQUFNLENBQUMsY0FBYyxDQUFDLEtBQWUsRUFBRSxTQUFpQjs7Ozs7Ozs7OztRQUM3RCxPQUFPO1lBQ0wsTUFBTSxFQUFFLEtBQUssQ0FBQyxZQUFZLENBQUMsU0FBUyxDQUFDO1NBQ3RDLENBQUM7S0FDSDs7QUFqQkgsb0NBdUJDOzs7QUFFRDs7R0FFRztBQUNILE1BQXNCLGNBQWM7SUFDbEM7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztPQXdCRztJQUNJLE1BQU0sQ0FBQyxLQUFLLENBQUMsUUFBYTtRQUMvQixPQUFPO1lBQ0wsTUFBTSxFQUFFLElBQUksQ0FBQyxTQUFTLENBQUM7Z0JBQ3JCLE1BQU0sRUFBRSxRQUFRO2FBQ2pCLENBQUM7U0FDSCxDQUFDO0tBQ0g7SUFFRDs7Ozs7Ozs7Ozs7Ozs7Ozs7OztPQW1CRztJQUNJLE1BQU0sQ0FBQyxVQUFVLENBQUMsUUFBZ0M7UUFDdkQsT0FBTztZQUNMLE1BQU0sRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDO2dCQUNyQixXQUFXLEVBQUUsUUFBUTthQUN0QixDQUFDO1NBQ0gsQ0FBQztLQUNIO0lBRUQ7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7T0FzQkc7SUFDSSxNQUFNLENBQUMsU0FBUyxDQUFDLFFBQWU7UUFDckMsT0FBTztZQUNMLE1BQU0sRUFBRSxJQUFJLENBQUMsU0FBUyxDQUFDO2dCQUNyQixVQUFVLEVBQUUsUUFBUTthQUNyQixDQUFDO1NBQ0gsQ0FBQztLQUNIO0lBQ0Q7Ozs7Ozs7Ozs7OztPQVlHO0lBQ0ksTUFBTSxDQUFDLGdCQUFnQixDQUFDLFFBQWdCO1FBQzdDLE9BQU87WUFDTCxNQUFNLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQztnQkFDckIsV0FBVyxFQUFFLFFBQVE7YUFDdEIsQ0FBQztTQUNILENBQUM7S0FDSDs7QUEvR0gsd0NBcUhDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ3VzdG9tUmVzb3VyY2UgfSBmcm9tICdhd3MtY2RrLWxpYi9jb3JlJztcbmltcG9ydCB7IElBcGlDYWxsIH0gZnJvbSAnLi9hcGktY2FsbC1iYXNlJztcblxuLyoqXG4gKiBSZXByZXNlbnRzIHRoZSBcImFjdHVhbFwiIHJlc3VsdHMgdG8gY29tcGFyZVxuICovXG5leHBvcnQgYWJzdHJhY3QgY2xhc3MgQWN0dWFsUmVzdWx0IHtcbiAgLyoqXG4gICAqIEdldCB0aGUgYWN0dWFsIHJlc3VsdHMgZnJvbSBhIEN1c3RvbVJlc291cmNlXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21DdXN0b21SZXNvdXJjZShjdXN0b21SZXNvdXJjZTogQ3VzdG9tUmVzb3VyY2UsIGF0dHJpYnV0ZTogc3RyaW5nKTogQWN0dWFsUmVzdWx0IHtcbiAgICByZXR1cm4ge1xuICAgICAgcmVzdWx0OiBjdXN0b21SZXNvdXJjZS5nZXRBdHRTdHJpbmcoYXR0cmlidXRlKSxcbiAgICB9O1xuICB9XG5cbiAgLyoqXG4gICAqIEdldCB0aGUgYWN0dWFsIHJlc3VsdHMgZnJvbSBhIEF3c0FwaUNhbGxcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZnJvbUF3c0FwaUNhbGwocXVlcnk6IElBcGlDYWxsLCBhdHRyaWJ1dGU6IHN0cmluZyk6IEFjdHVhbFJlc3VsdCB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHJlc3VsdDogcXVlcnkuZ2V0QXR0U3RyaW5nKGF0dHJpYnV0ZSksXG4gICAgfTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgYWN0dWFsIHJlc3VsdHMgYXMgYSBzdHJpbmdcbiAgICovXG4gIHB1YmxpYyBhYnN0cmFjdCByZXN1bHQ6IHN0cmluZztcbn1cblxuLyoqXG4gKiBSZXByZXNlbnRzIHRoZSBcImV4cGVjdGVkXCIgcmVzdWx0cyB0byBjb21wYXJlXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBFeHBlY3RlZFJlc3VsdCB7XG4gIC8qKlxuICAgKiBUaGUgYWN0dWFsIHJlc3VsdHMgbXVzdCBtYXRjaCBleGFjdGx5LiBNaXNzaW5nIGRhdGFcbiAgICogd2lsbCByZXN1bHQgaW4gYSBmYWlsdXJlXG4gICAqXG4gICAqIEBleGFtcGxlXG4gICAqIC8vIGFjdHVhbCByZXN1bHRzXG4gICAqIGNvbnN0IGFjdHVhbCA9IHtcbiAgICogICBzdHJpbmdQYXJhbTogJ2hlbGxvJyxcbiAgICogICBudW1iZXJQYXJhbTogMyxcbiAgICogICBib29sZWFuUGFyYW06IHRydWUsXG4gICAqIH07XG4gICAqIC8vIHBhc3NcbiAgICogRXhwZWN0ZWRSZXN1bHQuZXhhY3Qoe1xuICAgKiAgIHN0cmluZ1BhcmFtOiAnaGVsbG8nLFxuICAgKiAgIG51bWJlclBhcmFtOiAzLFxuICAgKiAgIGJvb2xlYW5QYXJhbTogdHJ1ZSxcbiAgICogfSlcbiAgICpcbiAgICogLy8gZmFpbFxuICAgKiBFeHBlY3RlZFJlc3VsdC5leGFjdCh7XG4gICAqICAgc3RyaW5nUGFyYW06ICdoZWxsbycsXG4gICAqIH0pO1xuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jZGsvYXBpL3YyL2RvY3MvYXdzLWNkay1saWIuYXNzZXJ0aW9ucy5NYXRjaC5odG1sI3N0YXRpYy1leGFjdHBhdHRlcm5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZXhhY3QoZXhwZWN0ZWQ6IGFueSk6IEV4cGVjdGVkUmVzdWx0IHtcbiAgICByZXR1cm4ge1xuICAgICAgcmVzdWx0OiBKU09OLnN0cmluZ2lmeSh7XG4gICAgICAgICRFeGFjdDogZXhwZWN0ZWQsXG4gICAgICB9KSxcbiAgICB9O1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBleHBlY3RlZCByZXN1bHRzIG11c3QgYmUgYSBzdWJzZXQgb2YgdGhlXG4gICAqIGFjdHVhbCByZXN1bHRzLlxuICAgKlxuICAgKiBAZXhhbXBsZVxuICAgKiAvLyBhY3R1YWwgcmVzdWx0c1xuICAgKiBjb25zdCBhY3R1YWwgPSB7XG4gICAqICAgc3RyaW5nUGFyYW06ICdoZWxsbycsXG4gICAqICAgbnVtYmVyUGFyYW06IDMsXG4gICAqICAgYm9vbGVhblBhcmFtOiB0cnVlLFxuICAgKiAgIG9iamVjdFBhcmFtOiB7IHByb3AxOiAndmFsdWUnLCBwcm9wMjogJ3ZhbHVlJyB9LFxuICAgKiB9O1xuICAgKiAvLyBwYXNzXG4gICAqIEV4cGVjdGVkUmVzdWx0Lm9iamVjdExpa2Uoe1xuICAgKiAgIHN0cmluZ1BhcmFtOiAnaGVsbG8nLFxuICAgKiAgIG9iamVjdFBhcmFtOiB7IHByb3AxOiAndmFsdWUnIH0sXG4gICAqIH0pO1xuICAgKlxuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jZGsvYXBpL3YyL2RvY3MvYXdzLWNkay1saWIuYXNzZXJ0aW9ucy5NYXRjaC5odG1sI3N0YXRpYy1vYmplY3R3YnJsaWtlcGF0dGVyblxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBvYmplY3RMaWtlKGV4cGVjdGVkOiB7IFtrZXk6IHN0cmluZ106IGFueSB9KTogRXhwZWN0ZWRSZXN1bHQge1xuICAgIHJldHVybiB7XG4gICAgICByZXN1bHQ6IEpTT04uc3RyaW5naWZ5KHtcbiAgICAgICAgJE9iamVjdExpa2U6IGV4cGVjdGVkLFxuICAgICAgfSksXG4gICAgfTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgYWN0dWFsIHJlc3VsdHMgbXVzdCBiZSBhIGxpc3QgYW5kIG11c3QgY29udGFpblxuICAgKiBhbiBpdGVtIHdpdGggdGhlIGV4cGVjdGVkIHJlc3VsdHMuXG4gICAqXG4gICAqIEBleGFtcGxlXG4gICAqIC8vIGFjdHVhbCByZXN1bHRzXG4gICAqIGNvbnN0IGFjdHVhbCA9IFtcbiAgICogICB7XG4gICAqICAgICBzdHJpbmdQYXJhbTogJ2hlbGxvJyxcbiAgICogICB9LFxuICAgKiAgIHtcbiAgICogICAgIHN0cmluZ1BhcmFtOiAnd29ybGQnLFxuICAgKiAgIH0sXG4gICAqIF07XG4gICAqIC8vIHBhc3NcbiAgICogRXhwZWN0ZWRSZXN1bHQuYXJyYXlXaXRoKFtcbiAgICogICB7XG4gICAqICAgICBzdHJpbmdQYXJhbTogJ2hlbGxvJyxcbiAgICogICB9LFxuICAgKiBdKTtcbiAgICpcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2RrL2FwaS92Mi9kb2NzL2F3cy1jZGstbGliLmFzc2VydGlvbnMuTWF0Y2guaHRtbCNzdGF0aWMtYXJyYXl3YnJ3aXRocGF0dGVyblxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBhcnJheVdpdGgoZXhwZWN0ZWQ6IGFueVtdKTogRXhwZWN0ZWRSZXN1bHQge1xuICAgIHJldHVybiB7XG4gICAgICByZXN1bHQ6IEpTT04uc3RyaW5naWZ5KHtcbiAgICAgICAgJEFycmF5V2l0aDogZXhwZWN0ZWQsXG4gICAgICB9KSxcbiAgICB9O1xuICB9XG4gIC8qKlxuICAgKiBBY3R1YWwgcmVzdWx0cyBpcyBhIHN0cmluZyB0aGF0IG1hdGNoZXNcbiAgICogdGhlIEV4cGVjdGVkIHJlc3VsdCByZWdleFxuICAgKlxuICAgKiBAZXhhbXBsZVxuICAgKiAvLyBhY3R1YWwgcmVzdWx0c1xuICAgKiBjb25zdCBhY3R1YWwgPSAnc29tZSBzdHJpbmcgdmFsdWUnO1xuICAgKlxuICAgKiAvLyBwYXNzXG4gICAqIEV4cGVjdGVkUmVzdWx0LnN0cmluZ0xpa2VSZWdleHAoJ3ZhbHVlJyk7XG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2Nkay9hcGkvdjIvZG9jcy9hd3MtY2RrLWxpYi5hc3NlcnRpb25zLk1hdGNoLmh0bWwjc3RhdGljLXN0cmluZ3dicmxpa2V3YnJyZWdleHBwYXR0ZXJuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHN0cmluZ0xpa2VSZWdleHAoZXhwZWN0ZWQ6IHN0cmluZyk6IEV4cGVjdGVkUmVzdWx0IHtcbiAgICByZXR1cm4ge1xuICAgICAgcmVzdWx0OiBKU09OLnN0cmluZ2lmeSh7XG4gICAgICAgICRTdHJpbmdMaWtlOiBleHBlY3RlZCxcbiAgICAgIH0pLFxuICAgIH07XG4gIH1cblxuICAvKipcbiAgICogVGhlIGV4cGVjdGVkIHJlc3VsdHMgZW5jb2RlZCBhcyBhIHN0cmluZ1xuICAgKi9cbiAgcHVibGljIGFic3RyYWN0IHJlc3VsdDogc3RyaW5nO1xufVxuIl19