"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EqualsAssertion = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("aws-cdk-lib/core");
const constructs_1 = require("constructs");
const hash_1 = require("./private/hash");
const providers_1 = require("./providers");
/**
 * Construct that creates a CustomResource to assert that two
 * values are equal
 */
class EqualsAssertion extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_integ_tests_alpha_EqualsAssertionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EqualsAssertion);
            }
            throw error;
        }
        const assertionProvider = new providers_1.AssertionsProvider(this, 'AssertionProvider');
        const properties = {
            actual: props.actual.result,
            expected: props.expected.result,
            failDeployment: props.failDeployment,
        };
        const resource = new core_1.CustomResource(this, 'Default', {
            serviceToken: assertionProvider.serviceToken,
            properties: {
                ...properties,
                salt: Date.now().toString(), // always update,
            },
            resourceType: providers_1.ASSERT_RESOURCE_TYPE,
        });
        this.result = resource.getAttString('data');
        new core_1.CfnOutput(this, 'AssertionResults', {
            value: this.result,
        }).overrideLogicalId(`AssertionResults${id}${(0, hash_1.md5hash)({ actual: props.actual.result, expected: props.expected.result })}`);
    }
}
exports.EqualsAssertion = EqualsAssertion;
_a = JSII_RTTI_SYMBOL_1;
EqualsAssertion[_a] = { fqn: "@aws-cdk/integ-tests-alpha.EqualsAssertion", version: "2.210.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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