import sys
from setuptools import setup
from setuptools import find_packages

NAME = "roseta"
VERSION = "0.1.3"
AUTHOR = "Ailln"
EMAIL = "kinggreenhall@gmail.com"
URL = "https://github.com/Ailln/roseta"
LICENSE = "MIT License"
DESCRIPTION = "From unstructured data to structured data."

if sys.version_info[:2] < (3, 6):
    raise RuntimeError("Python version >= 3.6 required.")

if __name__ == "__main__":
    setup(
        name=NAME,
        version=VERSION,
        author=AUTHOR,
        author_email=EMAIL,
        url=URL,
        license=LICENSE,
        description=DESCRIPTION,
        packages=find_packages(),
        include_package_data=True,
        install_requires=open("./requirements.txt", "r", encoding="utf-8").read().splitlines(),
        long_description=open("./README.md", "r", encoding="utf-8").read(),
        long_description_content_type='text/markdown',
        zip_safe=True,
        classifiers=[
            "Programming Language :: Python :: 3",
            "Programming Language :: Python :: 3.6",
            "Programming Language :: Python :: 3.7",
            "Programming Language :: Python :: 3.8",
            f"License :: OSI Approved :: {LICENSE}",
            "Operating System :: OS Independent",
        ],
        python_requires=">=3.6"
    )
