import unittest

from roseta import trans_height


class TestHeightConvert(unittest.TestCase):
    def setUp(self) -> None:
        self.height_data = {
            # pattern1
            "负零点八": [(-0.8, "cm"), (-0.8, "m")],
            "负零点八厘米": [(-0.8, "cm"), (-0.008, "m")],
            "零点八米": [(80, "cm"), (0.8, "m")],
            "零点八厘米": [(0.8, "cm"), (0.008, "m")],
            "八米": [(800, "cm"), (8, "m")],
            "八厘米": [(8, "cm"), (0.08, "m")],
            "八十米": [(8000, "cm"), (80, "m")],
            "八十厘米": [(80, "cm"), (0.8, "m")],
            "八十七米": [(8700, "cm"), (87, "m")],
            "八十七厘米": [(87, "cm"), (0.87, "m")],
            # pattern2
            "-0.8米": [(-80, "cm"), (-0.8, "m")],
            "0.8米": [(80, "cm"), (0.8, "m")],
            "0.8厘米": [(0.8, "cm"), (0.008, "m")],
            "1米": [(100, "cm"), (1, "m")],
            "1厘米": [(1, "cm"), (0.01, "m")],
            "1.8米": [(180, "cm"), (1.8, "m")],
            "1.8厘米": [(1.8, "cm"), (0.018, "m")],
            "18米": [(1800, "cm"), (18, "m")],
            "18厘米": [(18, "cm"), (0.18, "m")],
            "180米": [(18000, "cm"), (180, "m")],
            "180厘米": [(180, "cm"), (1.8, "m")],
            # pattern3
            "负一米八": [(-180, "cm"), (-1.8, "m")],
            "一米八": [(180, "cm"), (1.8, "m")],
            "一米八七": [(187, "cm"), (1.87, "m")],
            "一米8": [(180, "cm"), (1.8, "m")],
            "一米87": [(187, "cm"), (1.87, "m")],
            "1米八": [(180, "cm"), (1.8, "m")],
            "1米八七": [(187, "cm"), (1.87, "m")],
            "1米8": [(180, "cm"), (1.8, "m")],
            "1米87": [(187, "cm"), (1.87, "m")],
            # pattern4
            "八十几厘米": [(85, "cm"), (0.85, "m")],
            "八十多厘米": [(82, "cm"), (0.82, "m")],
            "一米八几": [(185, "cm"), (1.85, "m")],
            "一米八多": [(182, "cm"), (1.82, "m")],
            # pattern5
            "80几": [(85, "cm"), (85, "m")],
            "80几米": [(8500, "cm"), (85, "m")],
            "80几厘米": [(85, "cm"), (0.85, "m")],
            "80多": [(82, "cm"), (82, "m")],
            "80多米": [(8200, "cm"), (82, "m")],
            "80多厘米": [(82, "cm"), (0.82, "m")],
        }

    def test_trans_height(self) -> None:
        for key, value in self.height_data.items():
            self.assertEqual(trans_height(key), value[0])  # default unit: cm
            self.assertEqual(trans_height(key, unit="cm"), value[0])
            self.assertEqual(trans_height(key, unit="m"), value[1])


if __name__ == '__main__':
    unittest.main()
