import os
import json
CIMA_H = []
import os.path
def load_cima_h():
  CIMA_H = [
    {
        "age": 0,
        "lx": 1000000,
        "dx": 5368,
        "qx": 0.994632,
        "d_x": 1000000,
        "c_x": 5276.45613759659,
        "n_x": 26565816.0485112,
        "m_x": 103402.457625275,
        "s_x": 615047484.395005,
        "r_x": 5867165.28708664,
        "nom": "CIMA H",
    },
    {
        "age": 1,
        "lx": 994632,
        "dx": 726,
        "qx": 0.999270081799098,
        "d_x": 960997.101449275,
        "c_x": 689.487022019036,
        "n_x": 25565816.0485112,
        "m_x": 98126.001487678,
        "s_x": 588481668.346494,
        "r_x": 5763762.82946136,
        "nom": "CIMA H",
    },
    {
        "age": 2,
        "lx": 993906,
        "dx": 555,
        "qx": 0.999441597092683,
        "d_x": 927821.88615837,
        "c_x": 509.262981888137,
        "n_x": 24604818.9470619,
        "m_x": 97436.514465659,
        "s_x": 562915852.297983,
        "r_x": 5665636.82797368,
        "nom": "CIMA H",
    },
    {
        "age": 3,
        "lx": 993351,
        "dx": 473,
        "qx": 0.99952383397208,
        "d_x": 895945.688618036,
        "c_x": 419.343500775713,
        "n_x": 23676997.0609035,
        "m_x": 96927.2514837708,
        "s_x": 538311033.350921,
        "r_x": 5568200.31350802,
        "nom": "CIMA H",
    },
    {
        "age": 4,
        "lx": 992878,
        "dx": 404,
        "qx": 0.999593102072964,
        "d_x": 865235.816152903,
        "c_x": 346.058715187033,
        "n_x": 22781051.3722855,
        "m_x": 96507.9079829951,
        "s_x": 514634036.290017,
        "r_x": 5471273.06202425,
        "nom": "CIMA H",
    },
    {
        "age": 5,
        "lx": 992474,
        "dx": 369,
        "qx": 0.999628201847101,
        "d_x": 835636.476804747,
        "c_x": 305.389740048824,
        "n_x": 21915815.5561326,
        "m_x": 96161.8492678081,
        "s_x": 491852984.917732,
        "r_x": 5374765.15404126,
        "nom": "CIMA H",
    },
    {
        "age": 6,
        "lx": 992105,
        "dx": 332,
        "qx": 0.999665358001421,
        "d_x": 807078.056720943,
        "c_x": 265.476332943743,
        "n_x": 21080179.0793278,
        "m_x": 95856.4595277593,
        "s_x": 469937169.361599,
        "r_x": 5278603.30477345,
        "nom": "CIMA H",
    },
    {
        "age": 7,
        "lx": 991773,
        "dx": 313,
        "qx": 0.999684403588321,
        "d_x": 779524.613050274,
        "c_x": 241.81972007273,
        "n_x": 20273101.0226069,
        "m_x": 95590.9831948155,
        "s_x": 448856990.282272,
        "r_x": 5182746.84524569,
        "nom": "CIMA H",
    },
    {
        "age": 8,
        "lx": 991460,
        "dx": 313,
        "qx": 0.999684303955782,
        "d_x": 752926.181526164,
        "c_x": 233.642241616164,
        "n_x": 19493576.4095566,
        "m_x": 95349.1634747428,
        "s_x": 428583889.259665,
        "r_x": 5087155.86205087,
        "nom": "CIMA H",
    },
    {
        "age": 9,
        "lx": 991147,
        "dx": 294,
        "qx": 0.999703373969754,
        "d_x": 727235.251892819,
        "c_x": 212.038150468899,
        "n_x": 18740650.2280305,
        "m_x": 95115.5212331267,
        "s_x": 409090312.850108,
        "r_x": 4991806.69857613,
        "nom": "CIMA H",
    },
    {
        "age": 10,
        "lx": 990853,
        "dx": 312,
        "qx": 0.999685119790726,
        "d_x": 702434.333320769,
        "c_x": 217.410703428626,
        "n_x": 18013414.9761376,
        "m_x": 94903.4830826578,
        "s_x": 390349662.622078,
        "r_x": 4896691.17734301,
        "nom": "CIMA H",
    },
    {
        "age": 11,
        "lx": 990541,
        "dx": 313,
        "qx": 0.999684011060622,
        "d_x": 678466.812223084,
        "c_x": 210.731915561625,
        "n_x": 17310980.6428169,
        "m_x": 94686.0723792291,
        "s_x": 372336247.64594,
        "r_x": 4801787.69426035,
        "nom": "CIMA H",
    },
    {
        "age": 12,
        "lx": 990228,
        "dx": 368,
        "qx": 0.999628368416163,
        "d_x": 655316.351898248,
        "c_x": 239.383077670288,
        "n_x": 16632513.8305938,
        "m_x": 94475.3404636675,
        "s_x": 355025267.003123,
        "r_x": 4707101.62188112,
        "nom": "CIMA H",
    },
    {
        "age": 13,
        "lx": 989860,
        "dx": 438,
        "qx": 0.999557513183683,
        "d_x": 632920.594825582,
        "c_x": 275.282997320904,
        "n_x": 15977197.4786955,
        "m_x": 94235.9573859972,
        "s_x": 338392753.172529,
        "r_x": 4612626.28141745,
        "nom": "CIMA H",
    },
    {
        "age": 14,
        "lx": 989422,
        "dx": 538,
        "qx": 0.99945624819339,
        "d_x": 611246.894499126,
        "c_x": 326.698547545158,
        "n_x": 15344276.88387,
        "m_x": 93960.6743886763,
        "s_x": 322415555.693834,
        "r_x": 4518390.32403145,
        "nom": "CIMA H",
    },
    {
        "age": 15,
        "lx": 988884,
        "dx": 708,
        "qx": 0.99928404140425,
        "d_x": 590255.582508172,
        "c_x": 415.391720384986,
        "n_x": 14733029.9893708,
        "m_x": 93633.9758411312,
        "s_x": 307071278.809964,
        "r_x": 4424429.64964278,
        "nom": "CIMA H",
    },
    {
        "age": 16,
        "lx": 988176,
        "dx": 897,
        "qx": 0.999092266964589,
        "d_x": 569886.941014672,
        "c_x": 508.483273540943,
        "n_x": 14142774.4068627,
        "m_x": 93218.5841207462,
        "s_x": 292338248.820593,
        "r_x": 4330795.67380165,
        "nom": "CIMA H",
    },
    {
        "age": 17,
        "lx": 987279,
        "dx": 1113,
        "qx": 0.998872659096365,
        "d_x": 550115.59015639,
        "c_x": 609.59169690818,
        "n_x": 13572887.465848,
        "m_x": 92710.1008472052,
        "s_x": 278195474.413731,
        "r_x": 4237577.0896809,
        "nom": "CIMA H",
    },
    {
        "age": 18,
        "lx": 986166,
        "dx": 1318,
        "qx": 0.998663511011331,
        "d_x": 530913.451545777,
        "c_x": 697.459411630647,
        "n_x": 13022771.8756916,
        "m_x": 92100.509150297,
        "s_x": 264622586.947882,
        "r_x": 4144866.9888337,
        "nom": "CIMA H",
    },
    {
        "age": 19,
        "lx": 984848,
        "dx": 1466,
        "qx": 0.998511445421019,
        "d_x": 512274.291366039,
        "c_x": 749.544029858246,
        "n_x": 12491858.4241458,
        "m_x": 91403.0497386664,
        "s_x": 251599815.072191,
        "r_x": 4052766.4796834,
        "nom": "CIMA H",
    },
    {
        "age": 20,
        "lx": 983382,
        "dx": 1552,
        "qx": 0.998421773024115,
        "d_x": 494214.244564185,
        "c_x": 766.680727300286,
        "n_x": 11979584.1327798,
        "m_x": 90653.5057088081,
        "s_x": 239107956.648045,
        "r_x": 3961363.42994473,
        "nom": "CIMA H",
    },
    {
        "age": 21,
        "lx": 981830,
        "dx": 1603,
        "qx": 0.99836733446727,
        "d_x": 476748.079528065,
        "c_x": 765.096123974276,
        "n_x": 11485369.8882156,
        "m_x": 89886.8249815078,
        "s_x": 227128372.515265,
        "r_x": 3870709.92423592,
        "nom": "CIMA H",
    },
    {
        "age": 22,
        "lx": 980227,
        "dx": 1631,
        "qx": 0.998336099699355,
        "d_x": 459874.11533413,
        "c_x": 752.135505710636,
        "n_x": 11008621.8086875,
        "m_x": 89121.7288575336,
        "s_x": 215643002.62705,
        "r_x": 3780823.09925442,
        "nom": "CIMA H",
    },
    {
        "age": 23,
        "lx": 978596,
        "dx": 1653,
        "qx": 0.998310845333519,
        "d_x": 443583.507879581,
        "c_x": 736.503192042866,
        "n_x": 10548747.6933534,
        "m_x": 88369.5933518229,
        "s_x": 204634380.818362,
        "r_x": 3691701.37039688,
        "nom": "CIMA H",
    },
    {
        "age": 24,
        "lx": 976943,
        "dx": 1681,
        "qx": 0.998279326429485,
        "d_x": 427859.156258234,
        "c_x": 723.650961550837,
        "n_x": 10105164.1854738,
        "m_x": 87633.0901597801,
        "s_x": 194085633.125009,
        "r_x": 3603331.77704506,
        "nom": "CIMA H",
    },
    {
        "age": 25,
        "lx": 975262,
        "dx": 1710,
        "qx": 0.998246625009485,
        "d_x": 412679.179049428,
        "c_x": 711.241666164855,
        "n_x": 9677305.02921559,
        "m_x": 86909.4391982292,
        "s_x": 183980468.939535,
        "r_x": 3515698.68688528,
        "nom": "CIMA H",
    },
    {
        "age": 26,
        "lx": 973552,
        "dx": 1752,
        "qx": 0.998200404292734,
        "d_x": 398024.732075146,
        "c_x": 704.068366879016,
        "n_x": 9264625.85016616,
        "m_x": 86198.1975320644,
        "s_x": 174303163.910319,
        "r_x": 3428789.24768705,
        "nom": "CIMA H",
    },
    {
        "age": 27,
        "lx": 971800,
        "dx": 1796,
        "qx": 0.998151883103519,
        "d_x": 383872.897078182,
        "c_x": 697.343429132593,
        "n_x": 8866601.11809101,
        "m_x": 85494.1291651853,
        "s_x": 165038538.060153,
        "r_x": 3342591.05015499,
        "nom": "CIMA H",
    },
    {
        "age": 28,
        "lx": 970004,
        "dx": 1838,
        "qx": 0.998105162452938,
        "d_x": 370206.236802889,
        "c_x": 689.517888784365,
        "n_x": 8482728.22101283,
        "m_x": 84796.7857360527,
        "s_x": 156171936.942062,
        "r_x": 3257096.9209898,
        "nom": "CIMA H",
    },
    {
        "age": 29,
        "lx": 968166,
        "dx": 1885,
        "qx": 0.998053019833376,
        "d_x": 357009.42620796,
        "c_x": 683.236462842162,
        "n_x": 8112521.98420994,
        "m_x": 84107.2678472684,
        "s_x": 147689208.721049,
        "r_x": 3172300.13525375,
        "nom": "CIMA H",
    },
    {
        "age": 30,
        "lx": 966281,
        "dx": 1927,
        "qx": 0.998005756089585,
        "d_x": 344265.058875203,
        "c_x": 674.840356179267,
        "n_x": 7755512.55800198,
        "m_x": 83424.0313844262,
        "s_x": 139576686.736839,
        "r_x": 3088192.86740648,
        "nom": "CIMA H",
    },
    {
        "age": 31,
        "lx": 964354,
        "dx": 1964,
        "qx": 0.997963403480465,
        "d_x": 331959.913408669,
        "c_x": 664.538986803888,
        "n_x": 7411247.49912678,
        "m_x": 82749.1910282469,
        "s_x": 131821174.178837,
        "r_x": 3004768.83602205,
        "nom": "CIMA H",
    },
    {
        "age": 32,
        "lx": 962390,
        "dx": 2028,
        "qx": 0.99789274618398,
        "d_x": 320081.009666083,
        "c_x": 662.989396203294,
        "n_x": 7079287.58571811,
        "m_x": 82084.652041443,
        "s_x": 124409926.679711,
        "r_x": 2922019.64499381,
        "nom": "CIMA H",
    },
    {
        "age": 33,
        "lx": 960362,
        "dx": 2118,
        "qx": 0.997794581626512,
        "d_x": 308605.331146887,
        "c_x": 668.997103906935,
        "n_x": 6759206.57605203,
        "m_x": 81421.6626452397,
        "s_x": 117330639.093992,
        "r_x": 2839934.99295236,
        "nom": "CIMA H",
    },
    {
        "age": 34,
        "lx": 958244,
        "dx": 2244,
        "qx": 0.997658216487659,
        "d_x": 297511.813796541,
        "c_x": 684.826858428634,
        "n_x": 6450601.24490514,
        "m_x": 80752.6655413328,
        "s_x": 110571432.51794,
        "r_x": 2758513.33030712,
        "nom": "CIMA H",
    },
    {
        "age": 35,
        "lx": 956000,
        "dx": 2368,
        "qx": 0.997523012552301,
        "d_x": 286777.879745184,
        "c_x": 698.231247151397,
        "n_x": 6153089.4311086,
        "m_x": 80067.8386829042,
        "s_x": 104120831.273035,
        "r_x": 2677760.66476579,
        "nom": "CIMA H",
    },
    {
        "age": 36,
        "lx": 953632,
        "dx": 2516,
        "qx": 0.997361665715916,
        "d_x": 276393.75317563,
        "c_x": 716.783285119188,
        "n_x": 5866311.55136341,
        "m_x": 79369.6074357528,
        "s_x": 97967741.8419267,
        "r_x": 2597692.82608289,
        "nom": "CIMA H",
    },
    {
        "age": 37,
        "lx": 951116,
        "dx": 2671,
        "qx": 0.997191720042561,
        "d_x": 266342.544986203,
        "c_x": 735.208925506075,
        "n_x": 5589917.79818778,
        "m_x": 78652.8241506336,
        "s_x": 92101430.2905633,
        "r_x": 2518323.21864713,
        "nom": "CIMA H",
    },
    {
        "age": 38,
        "lx": 948445,
        "dx": 2849,
        "qx": 0.996996135780145,
        "d_x": 256613.121309473,
        "c_x": 757.685510598469,
        "n_x": 5323575.25320158,
        "m_x": 77917.6152251275,
        "s_x": 86511512.4923755,
        "r_x": 2439670.3944965,
        "nom": "CIMA H",
    },
    {
        "age": 39,
        "lx": 945596,
        "dx": 3057,
        "qx": 0.996767118304223,
        "d_x": 247190.618682151,
        "c_x": 785.509825771402,
        "n_x": 5066962.1318921,
        "m_x": 77159.929714529,
        "s_x": 81187937.2391739,
        "r_x": 2361752.77927137,
        "nom": "CIMA H",
    },
    {
        "age": 40,
        "lx": 942539,
        "dx": 3296,
        "qx": 0.996503062472746,
        "d_x": 238059.401599658,
        "c_x": 818.282072425064,
        "n_x": 4819771.51320995,
        "m_x": 76374.4198887577,
        "s_x": 76120975.1072818,
        "r_x": 2284592.84955684,
        "nom": "CIMA H",
    },
    {
        "age": 41,
        "lx": 939243,
        "dx": 3584,
        "qx": 0.996184161074397,
        "d_x": 229204.756274868,
        "c_x": 859.693186169572,
        "n_x": 4581712.1116103,
        "m_x": 75556.1378163326,
        "s_x": 71301203.5940719,
        "r_x": 2208218.42966809,
        "nom": "CIMA H",
    },
    {
        "age": 42,
        "lx": 935659,
        "dx": 3877,
        "qx": 0.995856396400825,
        "d_x": 220608.838496562,
        "c_x": 898.526592364193,
        "n_x": 4352507.35533543,
        "m_x": 74696.444630163,
        "s_x": 66719491.4824616,
        "r_x": 2132662.29185175,
        "nom": "CIMA H",
    },
    {
        "age": 43,
        "lx": 931782,
        "dx": 4194,
        "qx": 0.995498947178632,
        "d_x": 212265.432772326,
        "c_x": 939.124585440813,
        "n_x": 4131898.51683887,
        "m_x": 73797.9180377988,
        "s_x": 62366984.1271261,
        "r_x": 2057965.84722159,
        "nom": "CIMA H",
    },
    {
        "age": 44,
        "lx": 927588,
        "dx": 4523,
        "qx": 0.995123912771618,
        "d_x": 204164.265552915,
        "c_x": 978.545495163046,
        "n_x": 3919633.08406654,
        "m_x": 72858.793452358,
        "s_x": 58235085.6102873,
        "r_x": 1984167.92918379,
        "nom": "CIMA H",
    },
    {
        "age": 45,
        "lx": 923065,
        "dx": 4866,
        "qx": 0.994728431908912,
        "d_x": 196298.302207885,
        "c_x": 1017.15277672858,
        "n_x": 3715468.81851363,
        "m_x": 71880.247957195,
        "s_x": 54315452.5262207,
        "r_x": 1911309.13573143,
        "nom": "CIMA H",
    },
    {
        "age": 46,
        "lx": 918199,
        "dx": 5200,
        "qx": 0.994336739639229,
        "d_x": 188660.388735876,
        "c_x": 1050.2122464639,
        "n_x": 3519170.51630574,
        "m_x": 70863.0951804664,
        "s_x": 50599983.7077071,
        "r_x": 1839428.88777424,
        "nom": "CIMA H",
    },
    {
        "age": 47,
        "lx": 912999,
        "dx": 5515,
        "qx": 0.993959467644543,
        "d_x": 181248.266506956,
        "c_x": 1076.16509462067,
        "n_x": 3330510.12756987,
        "m_x": 69812.8829340025,
        "s_x": 47080813.1914014,
        "r_x": 1768565.79259377,
        "nom": "CIMA H",
    },
    {
        "age": 48,
        "lx": 907484,
        "dx": 5815,
        "qx": 0.993592173525924,
        "d_x": 174061.285496377,
        "c_x": 1096.33367499602,
        "n_x": 3149261.86106291,
        "m_x": 68736.7178393818,
        "s_x": 43750303.0638315,
        "r_x": 1698752.90965977,
        "nom": "CIMA H",
    },
    {
        "age": 49,
        "lx": 901669,
        "dx": 6108,
        "qx": 0.993225895533727,
        "d_x": 167097.517858031,
        "c_x": 1112.63242852289,
        "n_x": 2975200.57556653,
        "m_x": 67640.3841643858,
        "s_x": 40601041.2027686,
        "r_x": 1630016.19182039,
        "nom": "CIMA H",
    },
    {
        "age": 50,
        "lx": 895561,
        "dx": 6395,
        "qx": 0.992859224553101,
        "d_x": 160353.219145899,
        "c_x": 1125.51913866092,
        "n_x": 2808103.0577085,
        "m_x": 66527.7517358629,
        "s_x": 37625840.627202,
        "r_x": 1562375.807656,
        "nom": "CIMA H",
    },
    {
        "age": 51,
        "lx": 889166,
        "dx": 6704,
        "qx": 0.992460350485736,
        "d_x": 153824.321561151,
        "c_x": 1140.002992311,
        "n_x": 2647749.8385626,
        "m_x": 65402.232597202,
        "s_x": 34817737.5694935,
        "r_x": 1495848.05592014,
        "nom": "CIMA H",
    },
    {
        "age": 52,
        "lx": 882462,
        "dx": 7027,
        "qx": 0.992037050887177,
        "d_x": 147501.971101266,
        "c_x": 1154.52034216639,
        "n_x": 2493925.51700145,
        "m_x": 64262.229604891,
        "s_x": 32169987.7309309,
        "r_x": 1430445.82332294,
        "nom": "CIMA H",
    },
    {
        "age": 53,
        "lx": 875435,
        "dx": 7359,
        "qx": 0.991593893321606,
        "d_x": 141379.15015589,
        "c_x": 1168.18086731062,
        "n_x": 2346423.54590018,
        "m_x": 63107.7092627246,
        "s_x": 29676062.2139295,
        "r_x": 1366183.59371805,
        "nom": "CIMA H",
    },
    {
        "age": 54,
        "lx": 868076,
        "dx": 7711,
        "qx": 0.991117137209185,
        "d_x": 135449.953562878,
        "c_x": 1182.6647140584,
        "n_x": 2205044.39574429,
        "m_x": 61939.528395414,
        "s_x": 27329638.6680293,
        "r_x": 1303075.88445532,
        "nom": "CIMA H",
    },
    {
        "age": 55,
        "lx": 860365,
        "dx": 8066,
        "qx": 0.990624909195516,
        "d_x": 129707.024357832,
        "c_x": 1195.27766451904,
        "n_x": 2069594.44218142,
        "m_x": 60756.8636813556,
        "s_x": 25124594.272285,
        "r_x": 1241136.35605991,
        "nom": "CIMA H",
    },
    {
        "age": 56,
        "lx": 852299,
        "dx": 8425,
        "qx": 0.990114971389149,
        "d_x": 124145.902634298,
        "c_x": 1206.25783225262,
        "n_x": 1939887.41782358,
        "m_x": 59561.5860168365,
        "s_x": 23054999.8301036,
        "r_x": 1180379.49237855,
        "nom": "CIMA H",
    },
    {
        "age": 57,
        "lx": 843874,
        "dx": 8941,
        "qx": 0.98940481635884,
        "d_x": 118762.045251051,
        "c_x": 1236.84700505119,
        "n_x": 1815741.51518929,
        "m_x": 58355.3281845839,
        "s_x": 21115112.41228,
        "r_x": 1120817.90636172,
        "nom": "CIMA H",
    },
    {
        "age": 58,
        "lx": 834933,
        "dx": 9531,
        "qx": 0.988584712785337,
        "d_x": 113530.183161368,
        "c_x": 1273.87849656853,
        "n_x": 1696979.46993824,
        "m_x": 57118.4811795327,
        "s_x": 19299370.8970907,
        "r_x": 1062462.57817713,
        "nom": "CIMA H",
    },
    {
        "age": 59,
        "lx": 825402,
        "dx": 10282,
        "qx": 0.987543039634021,
        "d_x": 108438.84397396,
        "c_x": 1327.78203053829,
        "n_x": 1583449.28677687,
        "m_x": 55844.6026829642,
        "s_x": 17602391.4271525,
        "r_x": 1005344.0969976,
        "nom": "CIMA H",
    },
    {
        "age": 60,
        "lx": 815120,
        "dx": 11026,
        "qx": 0.986473157326529,
        "d_x": 103466.691393665,
        "c_x": 1375.70978302828,
        "n_x": 1475010.44280291,
        "m_x": 54516.8206524259,
        "s_x": 16018942.1403756,
        "r_x": 949499.494314635,
        "nom": "CIMA H",
    },
    {
        "age": 61,
        "lx": 804094,
        "dx": 11913,
        "qx": 0.985184567973396,
        "d_x": 98615.5688282496,
        "c_x": 1436.11635959414,
        "n_x": 1371543.75140924,
        "m_x": 53141.1108693976,
        "s_x": 14543931.6975727,
        "r_x": 894982.673662209,
        "nom": "CIMA H",
    },
    {
        "age": 62,
        "lx": 792181,
        "dx": 12791,
        "qx": 0.983853437535109,
        "d_x": 93869.1174603959,
        "c_x": 1489.8160095125,
        "n_x": 1272928.18258099,
        "m_x": 51704.9945098035,
        "s_x": 13172387.9461635,
        "r_x": 841841.562792812,
        "nom": "CIMA H",
    },
    {
        "age": 63,
        "lx": 779390,
        "dx": 13653,
        "qx": 0.982482454227024,
        "d_x": 89230.3902336207,
        "c_x": 1536.44096659707,
        "n_x": 1179059.0651206,
        "m_x": 50215.178500291,
        "s_x": 11899459.7635825,
        "r_x": 790136.568283008,
        "nom": "CIMA H",
    },
    {
        "age": 64,
        "lx": 765737,
        "dx": 14647,
        "qx": 0.980872022639627,
        "d_x": 84702.6983462442,
        "c_x": 1592.56116050637,
        "n_x": 1089828.67488698,
        "m_x": 48678.7375336939,
        "s_x": 10720400.6984619,
        "r_x": 739921.389782717,
        "nom": "CIMA H",
    },
    {
        "age": 65,
        "lx": 751090,
        "dx": 15611,
        "qx": 0.979215540081748,
        "d_x": 80272.9536714152,
        "c_x": 1639.97720768956,
        "n_x": 1005125.97654073,
        "m_x": 47086.1763731876,
        "s_x": 9630572.0235749,
        "r_x": 691242.652249023,
        "nom": "CIMA H",
    },
    {
        "age": 66,
        "lx": 735479,
        "dx": 16578,
        "qx": 0.977459587561304,
        "d_x": 75946.3996940212,
        "c_x": 1682.66969865962,
        "n_x": 924853.022869318,
        "m_x": 45446.199165498,
        "s_x": 8625446.04703417,
        "r_x": 644156.475875836,
        "nom": "CIMA H",
    },
    {
        "age": 67,
        "lx": 718901,
        "dx": 17371,
        "qx": 0.975836728562069,
        "d_x": 71724.1898760231,
        "c_x": 1703.5355823658,
        "n_x": 848906.623175296,
        "m_x": 43763.5294668384,
        "s_x": 7700593.02416486,
        "r_x": 598710.276710338,
        "nom": "CIMA H",
    },
    {
        "age": 68,
        "lx": 701530,
        "dx": 18178,
        "qx": 0.974088064658675,
        "d_x": 67624.2500554426,
        "c_x": 1722.39254975993,
        "n_x": 777182.433299273,
        "m_x": 42059.9938844726,
        "s_x": 6851686.40098956,
        "r_x": 554946.747243499,
        "nom": "CIMA H",
    },
    {
        "age": 69,
        "lx": 683352,
        "dx": 18989,
        "qx": 0.972211978599609,
        "d_x": 63644.4201550728,
        "c_x": 1738.39227687719,
        "n_x": 709558.18324383,
        "m_x": 40337.6013347127,
        "s_x": 6074503.96769028,
        "r_x": 512886.753359027,
        "nom": "CIMA H",
    },
    {
        "age": 70,
        "lx": 664363,
        "dx": 19812,
        "qx": 0.970178953373382,
        "d_x": 59783.4470007615,
        "c_x": 1752.40167213467,
        "n_x": 645913.763088758,
        "m_x": 38599.2090578355,
        "s_x": 5364945.78444645,
        "r_x": 472549.152024314,
        "nom": "CIMA H",
    },
    {
        "age": 71,
        "lx": 644551,
        "dx": 20634,
        "qx": 0.967987017319033,
        "d_x": 56039.2676717409,
        "c_x": 1763.39017210214,
        "n_x": 586130.316087996,
        "m_x": 36846.8073857008,
        "s_x": 4719032.02135769,
        "r_x": 433949.942966479,
        "nom": "CIMA H",
    },
    {
        "age": 72,
        "lx": 623917,
        "dx": 21427,
        "qx": 0.965657290953765,
        "d_x": 52410.9019964361,
        "c_x": 1769.23698551252,
        "n_x": 530091.048416255,
        "m_x": 35083.4172135986,
        "s_x": 4132901.7052697,
        "r_x": 397103.135580778,
        "nom": "CIMA H",
    },
    {
        "age": 73,
        "lx": 602490,
        "dx": 22187,
        "qx": 0.963174492522697,
        "d_x": 48899.4875732577,
        "c_x": 1770.03915541867,
        "n_x": 477680.146419819,
        "m_x": 33314.1802280861,
        "s_x": 3602810.65685344,
        "r_x": 362019.718367179,
        "nom": "CIMA H",
    },
    {
        "age": 74,
        "lx": 580303,
        "dx": 22921,
        "qx": 0.960501668955701,
        "d_x": 45506.0281429879,
        "c_x": 1766.75976994629,
        "n_x": 428780.658846561,
        "m_x": 31544.1410726674,
        "s_x": 3125130.51043362,
        "r_x": 328705.538139093,
        "nom": "CIMA H",
    },
    {
        "age": 75,
        "lx": 557382,
        "dx": 23642,
        "qx": 0.957583847343474,
        "d_x": 42230.5468395024,
        "c_x": 1760.70988973764,
        "n_x": 383274.630703574,
        "m_x": 29777.3813027212,
        "s_x": 2696349.85158706,
        "r_x": 297161.397066426,
        "nom": "CIMA H",
    },
    {
        "age": 76,
        "lx": 533740,
        "dx": 24351,
        "qx": 0.954376662794619,
        "d_x": 39071.7773120671,
        "c_x": 1752.18533646219,
        "n_x": 341044.083864071,
        "m_x": 28016.6714129835,
        "s_x": 2313075.22088349,
        "r_x": 267384.015763704,
        "nom": "CIMA H",
    },
    {
        "age": 77,
        "lx": 509389,
        "dx": 25022,
        "qx": 0.950878405305179,
        "d_x": 36028.2052565653,
        "c_x": 1739.58202230213,
        "n_x": 301972.306552004,
        "m_x": 26264.4860765213,
        "s_x": 1972031.13701942,
        "r_x": 239367.344350721,
        "nom": "CIMA H",
    },
    {
        "age": 78,
        "lx": 484367,
        "dx": 25672,
        "qx": 0.946998866561925,
        "d_x": 33099.9443095367,
        "c_x": 1724.41680023184,
        "n_x": 265944.101295439,
        "m_x": 24524.9040542192,
        "s_x": 1670058.83046742,
        "r_x": 213102.8582742,
        "nom": "CIMA H",
    },
    {
        "age": 79,
        "lx": 458695,
        "dx": 26347,
        "qx": 0.942560960987148,
        "d_x": 30285.6132796079,
        "c_x": 1709.91043591576,
        "n_x": 232844.156985902,
        "m_x": 22800.4872539874,
        "s_x": 1404114.72917198,
        "r_x": 188577.95421998,
        "nom": "CIMA H",
    },
    {
        "age": 80,
        "lx": 432348,
        "dx": 27049,
        "qx": 0.937436972068796,
        "d_x": 27580.7118424274,
        "c_x": 1696.10625419628,
        "n_x": 202558.543706294,
        "m_x": 21090.5768180716,
        "s_x": 1171270.57218607,
        "r_x": 165777.466965993,
        "nom": "CIMA H",
    },
    {
        "age": 81,
        "lx": 405299,
        "dx": 27722,
        "qx": 0.931601114239117,
        "d_x": 24980.8492725286,
        "c_x": 1679.52336915951,
        "n_x": 174977.831863867,
        "m_x": 19394.4705638753,
        "s_x": 968712.028479781,
        "r_x": 144686.890147921,
        "nom": "CIMA H",
    },
    {
        "age": 82,
        "lx": 377577,
        "dx": 28260,
        "qx": 0.925154339379782,
        "d_x": 22485.2048472726,
        "c_x": 1654.22012313587,
        "n_x": 149996.982591338,
        "m_x": 17714.9471947158,
        "s_x": 793734.196615914,
        "r_x": 125292.419584046,
        "nom": "CIMA H",
    },
    {
        "age": 83,
        "lx": 349317,
        "dx": 28556,
        "qx": 0.918251902999282,
        "d_x": 20098.8259287899,
        "c_x": 1615.02096940651,
        "n_x": 127511.777744066,
        "m_x": 16060.7270715799,
        "s_x": 643737.214024576,
        "r_x": 107577.47238933,
        "nom": "CIMA H",
    },
    {
        "age": 84,
        "lx": 320761,
        "dx": 28543,
        "qx": 0.911014743064151,
        "d_x": 17831.6764803503,
        "c_x": 1559.69636506317,
        "n_x": 107412.951815276,
        "m_x": 14445.7061021734,
        "s_x": 516225.43628051,
        "r_x": 91516.7453177503,
        "nom": "CIMA H",
    },
    {
        "age": 85,
        "lx": 292218,
        "dx": 28248,
        "qx": 0.903332443586637,
        "d_x": 15695.5750407241,
        "c_x": 1491.37822298468,
        "n_x": 89581.2753349253,
        "m_x": 12886.0097371103,
        "s_x": 408812.484465234,
        "r_x": 77071.0392155769,
        "nom": "CIMA H",
    },
    {
        "age": 86,
        "lx": 263970,
        "dx": 27685,
        "qx": 0.89512065765049,
        "d_x": 13698.8619855408,
        "c_x": 1412.22622073816,
        "n_x": 73885.7002942012,
        "m_x": 11394.6315141256,
        "s_x": 319231.209130309,
        "r_x": 64185.0294784666,
        "nom": "CIMA H",
    },
    {
        "age": 87,
        "lx": 236285,
        "dx": 26840,
        "qx": 0.886408362782233,
        "d_x": 11847.4728015078,
        "c_x": 1322.82350929015,
        "n_x": 60186.8383086605,
        "m_x": 9982.40529338741,
        "s_x": 245345.508836108,
        "r_x": 52790.3979643411,
        "nom": "CIMA H",
    },
    {
        "age": 88,
        "lx": 209445,
        "dx": 25718,
        "qx": 0.877208813769725,
        "d_x": 10146.5690522624,
        "c_x": 1224.66198016962,
        "n_x": 48339.3655071527,
        "m_x": 8659.58178409726,
        "s_x": 185158.670527448,
        "r_x": 42807.9926709536,
        "nom": "CIMA H",
    },
    {
        "age": 89,
        "lx": 183727,
        "dx": 24318,
        "qx": 0.867640575418964,
        "d_x": 8599.67130644222,
        "c_x": 1118.83629818341,
        "n_x": 38192.7964548903,
        "m_x": 7434.91980392764,
        "s_x": 136819.305020295,
        "r_x": 34148.4108868564,
        "nom": "CIMA H",
    },
    {
        "age": 90,
        "lx": 159409,
        "dx": 22676,
        "qx": 0.857749562446286,
        "d_x": 7209.10508283621,
        "c_x": 1008.00988741395,
        "n_x": 29593.125148448,
        "m_x": 6316.08350574423,
        "s_x": 98626.5085654047,
        "r_x": 26713.4910829288,
        "nom": "CIMA H",
    },
    {
        "age": 91,
        "lx": 136733,
        "dx": 21960,
        "qx": 0.839395025341359,
        "d_x": 5974.49925645609,
        "c_x": 943.170762917332,
        "n_x": 22384.0200656118,
        "m_x": 5308.07361833027,
        "s_x": 69033.3834169567,
        "r_x": 20397.4075771845,
        "nom": "CIMA H",
    },
    {
        "age": 92,
        "lx": 114773,
        "dx": 21943,
        "qx": 0.808813919650092,
        "d_x": 4845.37676789845,
        "c_x": 910.570648904684,
        "n_x": 16409.5208091557,
        "m_x": 4364.90285541294,
        "s_x": 46649.3633513448,
        "r_x": 15089.3339588543,
        "nom": "CIMA H",
    },
    {
        "age": 93,
        "lx": 92830,
        "dx": 21051,
        "qx": 0.773230636647635,
        "d_x": 3786.48132929994,
        "c_x": 844.014728986785,
        "n_x": 11564.1440412573,
        "m_x": 3454.33220650826,
        "s_x": 30239.8425421891,
        "r_x": 10724.4311034413,
        "nom": "CIMA H",
    },
    {
        "age": 94,
        "lx": 71779,
        "dx": 19222,
        "qx": 0.732205798353279,
        "d_x": 2828.81484918742,
        "c_x": 744.621406929799,
        "n_x": 7777.66271195735,
        "m_x": 2610.31747752147,
        "s_x": 18675.6985009318,
        "r_x": 7270.09889693306,
        "nom": "CIMA H",
    },
    {
        "age": 95,
        "lx": 52557,
        "dx": 16535,
        "qx": 0.685389196491428,
        "d_x": 2001.2315314424,
        "c_x": 618.871942906816,
        "n_x": 4948.84786276993,
        "m_x": 1865.69607059167,
        "s_x": 10898.0357889744,
        "r_x": 4659.78141941158,
        "nom": "CIMA H",
    },
    {
        "age": 96,
        "lx": 36022,
        "dx": 13233,
        "qx": 0.632641163733274,
        "d_x": 1325.23910273296,
        "c_x": 478.535936535494,
        "n_x": 2947.61633132754,
        "m_x": 1246.82412768486,
        "s_x": 5949.18792620449,
        "r_x": 2794.08534881991,
        "nom": "CIMA H",
    },
    {
        "age": 97,
        "lx": 22789,
        "dx": 9706,
        "qx": 0.574092764052833,
        "d_x": 810.049090026881,
        "c_x": 339.122169690216,
        "n_x": 1622.37722859457,
        "m_x": 768.288191149365,
        "s_x": 3001.57159487695,
        "r_x": 1547.26122113505,
        "nom": "CIMA H",
    },
    {
        "age": 98,
        "lx": 13083,
        "dx": 6405,
        "qx": 0.510433386837881,
        "d_x": 449.317218465714,
        "c_x": 216.21941076,
        "n_x": 812.32813856769,
        "m_x": 429.166021459149,
        "s_x": 1379.19436628238,
        "r_x": 778.973029985684,
        "nom": "CIMA H",
    },
    {
        "age": 99,
        "lx": 6678,
        "dx": 3723,
        "qx": 0.442497753818509,
        "d_x": 221.590830517904,
        "c_x": 121.43062541862,
        "n_x": 363.010920101977,
        "m_x": 212.946610699149,
        "s_x": 566.866227714688,
        "r_x": 349.807008526536,
        "nom": "CIMA H",
    },
    {
        "age": 100,
        "lx": 2955,
        "dx": 1855,
        "qx": 0.372250423011844,
        "d_x": 94.7376277980196,
        "c_x": 58.4573009796888,
        "n_x": 141.420089584073,
        "m_x": 91.5159852805294,
        "s_x": 203.855307612712,
        "r_x": 136.860397827387,
        "nom": "CIMA H",
    },
    {
        "age": 101,
        "lx": 1100,
        "dx": 768,
        "qx": 0.301818181818182,
        "d_x": 34.0735478482623,
        "c_x": 23.3838338228842,
        "n_x": 46.6824617860531,
        "m_x": 33.0586843008406,
        "s_x": 62.435218028639,
        "r_x": 45.3444125468572,
        "nom": "CIMA H",
    },
    {
        "age": 102,
        "lx": 332,
        "dx": 254,
        "qx": 0.234939759036145,
        "d_x": 9.93624759387183,
        "c_x": 7.47218924996552,
        "n_x": 12.6089139377909,
        "m_x": 9.67485047795644,
        "s_x": 15.7527562425859,
        "r_x": 12.2857282460165,
        "nom": "CIMA H",
    },
    {
        "age": 104,
        "lx": 13,
        "dx": 11,
        "qx": 0.153846153846154,
        "d_x": 0.363200948357833,
        "c_x": 0.302082892992369,
        "n_x": 0.417188454616894,
        "m_x": 0.355149716530774,
        "s_x": 0.471175960875955,
        "r_x": 0.408216540069179,
        "nom": "CIMA H",
    },
    {
        "age": 105,
        "lx": 2,
        "dx": 2,
        "qx": 0,
        "d_x": 0.0539875062590611,
        "c_x": 0.0530668235384048,
        "n_x": 0.0539875062590611,
        "m_x": 0.0530668235384048,
        "s_x": 0.0539875062590611,
        "r_x": 0.0530668235384048,
        "nom": "CIMA H",
    },
    {
        "age": 103,
        "lx": 78,
        "dx": 65,
        "qx": 0.166666666666667,
        "d_x": 2.25547788930214,
        "c_x": 1.84751151146015,
        "n_x": 2.67266634391904,
        "m_x": 2.20266122799092,
        "s_x": 3.14384230479499,
        "r_x": 2.6108777680601,
        "nom": "CIMA H",
    },
    {
        "age": 106,
        "lx": 0,
        "dx": 0,
        "qx": 0,
        "d_x": 0,
        "c_x": 0,
        "n_x": 0,
        "m_x": 0,
        "s_x": 0,
        "r_x": 0,
        "nom": "CIMA H",
    },
  ]
  return CIMA_H



if __name__ == '__main__':
  load_cima_h()