# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP WebAuthn Domain Commands"""

from typing import List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from .types import AuthenticatorId
    from .types import Credential
    from .types import VirtualAuthenticatorOptions

class EnableParameters(TypedDict, total=False):
    enableUI: "bool"
    """Whether to enable the WebAuthn user interface. Enabling the UI is
recommended for debugging and demo purposes, as it is closer to the real
experience. Disabling the UI is recommended for automated testing.
Supported at the embedder's discretion if UI is available.
Defaults to false."""





class AddVirtualAuthenticatorParameters(TypedDict):
    options: "VirtualAuthenticatorOptions"


class AddVirtualAuthenticatorReturns(TypedDict):
    authenticatorId: "AuthenticatorId"



class SetResponseOverrideBitsParameters(TypedDict):
    authenticatorId: "AuthenticatorId"
    isBogusSignature: "NotRequired[bool]"
    """If isBogusSignature is set, overrides the signature in the authenticator response to be zero.
Defaults to false."""
    isBadUV: "NotRequired[bool]"
    """If isBadUV is set, overrides the UV bit in the flags in the authenticator response to
be zero. Defaults to false."""
    isBadUP: "NotRequired[bool]"
    """If isBadUP is set, overrides the UP bit in the flags in the authenticator response to
be zero. Defaults to false."""





class RemoveVirtualAuthenticatorParameters(TypedDict):
    authenticatorId: "AuthenticatorId"





class AddCredentialParameters(TypedDict):
    authenticatorId: "AuthenticatorId"
    credential: "Credential"





class GetCredentialParameters(TypedDict):
    authenticatorId: "AuthenticatorId"
    credentialId: "str"


class GetCredentialReturns(TypedDict):
    credential: "Credential"



class GetCredentialsParameters(TypedDict):
    authenticatorId: "AuthenticatorId"


class GetCredentialsReturns(TypedDict):
    credentials: "List[Credential]"



class RemoveCredentialParameters(TypedDict):
    authenticatorId: "AuthenticatorId"
    credentialId: "str"





class ClearCredentialsParameters(TypedDict):
    authenticatorId: "AuthenticatorId"





class SetUserVerifiedParameters(TypedDict):
    authenticatorId: "AuthenticatorId"
    isUserVerified: "bool"





class SetAutomaticPresenceSimulationParameters(TypedDict):
    authenticatorId: "AuthenticatorId"
    enabled: "bool"





class SetCredentialPropertiesParameters(TypedDict):
    authenticatorId: "AuthenticatorId"
    credentialId: "str"
    backupEligibility: "NotRequired[bool]"
    backupState: "NotRequired[bool]"


