# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Tracing Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import GetCategoriesReturns
    from .commands import RecordClockSyncMarkerParameters
    from .commands import RequestMemoryDumpParameters
    from .commands import RequestMemoryDumpReturns
    from .commands import StartParameters

class TracingClient:
    """Client for Tracing domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def end(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Stop trace events collection."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Tracing.end",
            params=params,
            session_id=session_id,
        ))

    async def getCategories(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "GetCategoriesReturns":
        """Gets supported tracing categories."""
        return cast("GetCategoriesReturns", await self._client.send_raw(
            method="Tracing.getCategories",
            params=params,
            session_id=session_id,
        ))

    async def recordClockSyncMarker(
        self,
        params: "RecordClockSyncMarkerParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Record a clock sync marker in the trace."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Tracing.recordClockSyncMarker",
            params=params,
            session_id=session_id,
        ))

    async def requestMemoryDump(
        self,
        params: Optional["RequestMemoryDumpParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "RequestMemoryDumpReturns":
        """Request a global memory dump."""
        return cast("RequestMemoryDumpReturns", await self._client.send_raw(
            method="Tracing.requestMemoryDump",
            params=params,
            session_id=session_id,
        ))

    async def start(
        self,
        params: Optional["StartParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Start trace events collection."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Tracing.start",
            params=params,
            session_id=session_id,
        ))


