# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Target Domain Commands"""

from typing import List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..browser.types import BrowserContextID
    from .types import RemoteLocation
    from .types import SessionID
    from .types import TargetFilter
    from .types import TargetID
    from .types import TargetInfo
    from .types import WindowState

class ActivateTargetParameters(TypedDict):
    targetId: "TargetID"





class AttachToTargetParameters(TypedDict):
    targetId: "TargetID"
    flatten: "NotRequired[bool]"
    """Enables \"flat\" access to the session via specifying sessionId attribute in the commands.
We plan to make this the default, deprecate non-flattened mode,
and eventually retire it. See crbug.com/991325."""


class AttachToTargetReturns(TypedDict):
    sessionId: "SessionID"
    """Id assigned to the session."""



class AttachToBrowserTargetReturns(TypedDict):
    sessionId: "SessionID"
    """Id assigned to the session."""



class CloseTargetParameters(TypedDict):
    targetId: "TargetID"


class CloseTargetReturns(TypedDict):
    success: "bool"
    """Always set to true. If an error occurs, the response indicates protocol error."""



class ExposeDevToolsProtocolParameters(TypedDict):
    targetId: "TargetID"
    bindingName: "NotRequired[str]"
    """Binding name, 'cdp' if not specified."""
    inheritPermissions: "NotRequired[bool]"
    """If true, inherits the current root session's permissions (default: false)."""





class CreateBrowserContextParameters(TypedDict, total=False):
    disposeOnDetach: "bool"
    """If specified, disposes this context when debugging session disconnects."""
    proxyServer: "str"
    """Proxy server, similar to the one passed to --proxy-server"""
    proxyBypassList: "str"
    """Proxy bypass list, similar to the one passed to --proxy-bypass-list"""
    originsWithUniversalNetworkAccess: "List[str]"
    """An optional list of origins to grant unlimited cross-origin access to.
Parts of the URL other than those constituting origin are ignored."""


class CreateBrowserContextReturns(TypedDict):
    browserContextId: "BrowserContextID"
    """The id of the context created."""



class GetBrowserContextsReturns(TypedDict):
    browserContextIds: "List[BrowserContextID]"
    """An array of browser context ids."""



class CreateTargetParameters(TypedDict):
    url: "str"
    """The initial URL the page will be navigated to. An empty string indicates about:blank."""
    left: "NotRequired[int]"
    """Frame left origin in DIP (requires newWindow to be true or headless shell)."""
    top: "NotRequired[int]"
    """Frame top origin in DIP (requires newWindow to be true or headless shell)."""
    width: "NotRequired[int]"
    """Frame width in DIP (requires newWindow to be true or headless shell)."""
    height: "NotRequired[int]"
    """Frame height in DIP (requires newWindow to be true or headless shell)."""
    windowState: "NotRequired[WindowState]"
    """Frame window state (requires newWindow to be true or headless shell).
Default is normal."""
    browserContextId: "NotRequired[BrowserContextID]"
    """The browser context to create the page in."""
    enableBeginFrameControl: "NotRequired[bool]"
    """Whether BeginFrames for this target will be controlled via DevTools (headless shell only,
not supported on MacOS yet, false by default)."""
    newWindow: "NotRequired[bool]"
    """Whether to create a new Window or Tab (false by default, not supported by headless shell)."""
    background: "NotRequired[bool]"
    """Whether to create the target in background or foreground (false by default, not supported
by headless shell)."""
    forTab: "NotRequired[bool]"
    """Whether to create the target of type \"tab\"."""
    hidden: "NotRequired[bool]"
    """Whether to create a hidden target. The hidden target is observable via protocol, but not
present in the tab UI strip. Cannot be created with `forTab: true`, `newWindow: true` or
`background: false`. The life-time of the tab is limited to the life-time of the session."""


class CreateTargetReturns(TypedDict):
    targetId: "TargetID"
    """The id of the page opened."""



class DetachFromTargetParameters(TypedDict, total=False):
    sessionId: "SessionID"
    """Session to detach."""
    targetId: "TargetID"
    """Deprecated."""





class DisposeBrowserContextParameters(TypedDict):
    browserContextId: "BrowserContextID"





class GetTargetInfoParameters(TypedDict, total=False):
    targetId: "TargetID"


class GetTargetInfoReturns(TypedDict):
    targetInfo: "TargetInfo"



class GetTargetsParameters(TypedDict, total=False):
    filter: "TargetFilter"
    """Only targets matching filter will be reported. If filter is not specified
and target discovery is currently enabled, a filter used for target discovery
is used for consistency."""


class GetTargetsReturns(TypedDict):
    targetInfos: "List[TargetInfo]"
    """The list of targets."""



class SendMessageToTargetParameters(TypedDict):
    message: "str"
    sessionId: "NotRequired[SessionID]"
    """Identifier of the session."""
    targetId: "NotRequired[TargetID]"
    """Deprecated."""





class SetAutoAttachParameters(TypedDict):
    autoAttach: "bool"
    """Whether to auto-attach to related targets."""
    waitForDebuggerOnStart: "bool"
    """Whether to pause new targets when attaching to them. Use `Runtime.runIfWaitingForDebugger`
to run paused targets."""
    flatten: "NotRequired[bool]"
    """Enables \"flat\" access to the session via specifying sessionId attribute in the commands.
We plan to make this the default, deprecate non-flattened mode,
and eventually retire it. See crbug.com/991325."""
    filter: "NotRequired[TargetFilter]"
    """Only targets matching filter will be attached."""





class AutoAttachRelatedParameters(TypedDict):
    targetId: "TargetID"
    waitForDebuggerOnStart: "bool"
    """Whether to pause new targets when attaching to them. Use `Runtime.runIfWaitingForDebugger`
to run paused targets."""
    filter: "NotRequired[TargetFilter]"
    """Only targets matching filter will be attached."""





class SetDiscoverTargetsParameters(TypedDict):
    discover: "bool"
    """Whether to discover available targets."""
    filter: "NotRequired[TargetFilter]"
    """Only targets matching filter will be attached. If `discover` is false,
`filter` must be omitted or empty."""





class SetRemoteLocationsParameters(TypedDict):
    locations: "List[RemoteLocation]"
    """List of remote locations."""


