# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP PerformanceTimeline Domain Types"""

from typing import List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..dom.types import BackendNodeId
    from ..dom.types import Rect
    from ..network.types import TimeSinceEpoch
    from ..page.types import FrameId

class LargestContentfulPaint(TypedDict):
    """See https://github.com/WICG/LargestContentfulPaint and largest_contentful_paint.idl"""

    renderTime: "TimeSinceEpoch"
    loadTime: "TimeSinceEpoch"
    size: "float"
    """The number of pixels being painted."""
    elementId: "NotRequired[str]"
    """The id attribute of the element, if available."""
    url: "NotRequired[str]"
    """The URL of the image (may be trimmed)."""
    nodeId: "NotRequired[BackendNodeId]"



class LayoutShiftAttribution(TypedDict):
    previousRect: "Rect"
    currentRect: "Rect"
    nodeId: "NotRequired[BackendNodeId]"



class LayoutShift(TypedDict):
    """See https://wicg.github.io/layout-instability/#sec-layout-shift and layout_shift.idl"""

    value: "float"
    """Score increment produced by this event."""
    hadRecentInput: "bool"
    lastInputTime: "TimeSinceEpoch"
    sources: "List[LayoutShiftAttribution]"



class TimelineEvent(TypedDict):
    frameId: "FrameId"
    """Identifies the frame that this event is related to. Empty for non-frame targets."""
    type: "str"
    """The event type, as specified in https://w3c.github.io/performance-timeline/#dom-performanceentry-entrytype
This determines which of the optional \"details\" fields is present."""
    name: "str"
    """Name may be empty depending on the type."""
    time: "TimeSinceEpoch"
    """Time in seconds since Epoch, monotonically increasing within document lifetime."""
    duration: "NotRequired[float]"
    """Event duration, if applicable."""
    lcpDetails: "NotRequired[LargestContentfulPaint]"
    layoutShiftDetails: "NotRequired[LayoutShift]"
