# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP LayerTree Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import CompositingReasonsParameters
    from .commands import CompositingReasonsReturns
    from .commands import LoadSnapshotParameters
    from .commands import LoadSnapshotReturns
    from .commands import MakeSnapshotParameters
    from .commands import MakeSnapshotReturns
    from .commands import ProfileSnapshotParameters
    from .commands import ProfileSnapshotReturns
    from .commands import ReleaseSnapshotParameters
    from .commands import ReplaySnapshotParameters
    from .commands import ReplaySnapshotReturns
    from .commands import SnapshotCommandLogParameters
    from .commands import SnapshotCommandLogReturns

class LayerTreeClient:
    """Client for LayerTree domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def compositingReasons(
        self,
        params: "CompositingReasonsParameters",
        session_id: Optional[str] = None,
    ) -> "CompositingReasonsReturns":
        """Provides the reasons why the given layer was composited."""
        return cast("CompositingReasonsReturns", await self._client.send_raw(
            method="LayerTree.compositingReasons",
            params=params,
            session_id=session_id,
        ))

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disables compositing tree inspection."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="LayerTree.disable",
            params=params,
            session_id=session_id,
        ))

    async def enable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables compositing tree inspection."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="LayerTree.enable",
            params=params,
            session_id=session_id,
        ))

    async def loadSnapshot(
        self,
        params: "LoadSnapshotParameters",
        session_id: Optional[str] = None,
    ) -> "LoadSnapshotReturns":
        """Returns the snapshot identifier."""
        return cast("LoadSnapshotReturns", await self._client.send_raw(
            method="LayerTree.loadSnapshot",
            params=params,
            session_id=session_id,
        ))

    async def makeSnapshot(
        self,
        params: "MakeSnapshotParameters",
        session_id: Optional[str] = None,
    ) -> "MakeSnapshotReturns":
        """Returns the layer snapshot identifier."""
        return cast("MakeSnapshotReturns", await self._client.send_raw(
            method="LayerTree.makeSnapshot",
            params=params,
            session_id=session_id,
        ))

    async def profileSnapshot(
        self,
        params: "ProfileSnapshotParameters",
        session_id: Optional[str] = None,
    ) -> "ProfileSnapshotReturns":
        return cast("ProfileSnapshotReturns", await self._client.send_raw(
            method="LayerTree.profileSnapshot",
            params=params,
            session_id=session_id,
        ))

    async def releaseSnapshot(
        self,
        params: "ReleaseSnapshotParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Releases layer snapshot captured by the back-end."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="LayerTree.releaseSnapshot",
            params=params,
            session_id=session_id,
        ))

    async def replaySnapshot(
        self,
        params: "ReplaySnapshotParameters",
        session_id: Optional[str] = None,
    ) -> "ReplaySnapshotReturns":
        """Replays the layer snapshot and returns the resulting bitmap."""
        return cast("ReplaySnapshotReturns", await self._client.send_raw(
            method="LayerTree.replaySnapshot",
            params=params,
            session_id=session_id,
        ))

    async def snapshotCommandLog(
        self,
        params: "SnapshotCommandLogParameters",
        session_id: Optional[str] = None,
    ) -> "SnapshotCommandLogReturns":
        """Replays the layer snapshot and returns canvas log."""
        return cast("SnapshotCommandLogReturns", await self._client.send_raw(
            method="LayerTree.snapshotCommandLog",
            params=params,
            session_id=session_id,
        ))


