# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP IndexedDB Domain Types"""

from typing import List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..runtime.types import RemoteObject

class DatabaseWithObjectStores(TypedDict):
    """Database with an array of object stores."""

    name: "str"
    """Database name."""
    version: "float"
    """Database version (type is not 'integer', as the standard
requires the version number to be 'unsigned long long')"""
    objectStores: "List[ObjectStore]"
    """Object stores in this database."""



class ObjectStore(TypedDict):
    """Object store."""

    name: "str"
    """Object store name."""
    keyPath: "KeyPath"
    """Object store key path."""
    autoIncrement: "bool"
    """If true, object store has auto increment flag set."""
    indexes: "List[ObjectStoreIndex]"
    """Indexes in this object store."""



class ObjectStoreIndex(TypedDict):
    """Object store index."""

    name: "str"
    """Index name."""
    keyPath: "KeyPath"
    """Index key path."""
    unique: "bool"
    """If true, index is unique."""
    multiEntry: "bool"
    """If true, index allows multiple entries for a key."""



class Key(TypedDict):
    """Key."""

    type: "str"
    """Key type."""
    number: "NotRequired[float]"
    """Number value."""
    string: "NotRequired[str]"
    """String value."""
    date: "NotRequired[float]"
    """Date value."""
    array: "NotRequired[List[Key]]"
    """Array value."""



class KeyRange(TypedDict):
    """Key range."""

    lower: "NotRequired[Key]"
    """Lower bound."""
    upper: "NotRequired[Key]"
    """Upper bound."""
    lowerOpen: "bool"
    """If true lower bound is open."""
    upperOpen: "bool"
    """If true upper bound is open."""



class DataEntry(TypedDict):
    """Data entry."""

    key: "RemoteObject"
    """Key object."""
    primaryKey: "RemoteObject"
    """Primary key object."""
    value: "RemoteObject"
    """Value object."""



class KeyPath(TypedDict):
    """Key path."""

    type: "str"
    """Key path type."""
    string: "NotRequired[str]"
    """String value."""
    array: "NotRequired[List[str]]"
    """Array value."""
