# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP HeapProfiler Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import AddInspectedHeapObjectParameters
    from .commands import GetHeapObjectIdParameters
    from .commands import GetHeapObjectIdReturns
    from .commands import GetObjectByHeapObjectIdParameters
    from .commands import GetObjectByHeapObjectIdReturns
    from .commands import GetSamplingProfileReturns
    from .commands import StartSamplingParameters
    from .commands import StartTrackingHeapObjectsParameters
    from .commands import StopSamplingReturns
    from .commands import StopTrackingHeapObjectsParameters
    from .commands import TakeHeapSnapshotParameters

class HeapProfilerClient:
    """Client for HeapProfiler domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def addInspectedHeapObject(
        self,
        params: "AddInspectedHeapObjectParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables console to refer to the node with given id via $x (see Command Line API for more details
$x functions)."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="HeapProfiler.addInspectedHeapObject",
            params=params,
            session_id=session_id,
        ))

    async def collectGarbage(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="HeapProfiler.collectGarbage",
            params=params,
            session_id=session_id,
        ))

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="HeapProfiler.disable",
            params=params,
            session_id=session_id,
        ))

    async def enable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="HeapProfiler.enable",
            params=params,
            session_id=session_id,
        ))

    async def getHeapObjectId(
        self,
        params: "GetHeapObjectIdParameters",
        session_id: Optional[str] = None,
    ) -> "GetHeapObjectIdReturns":
        return cast("GetHeapObjectIdReturns", await self._client.send_raw(
            method="HeapProfiler.getHeapObjectId",
            params=params,
            session_id=session_id,
        ))

    async def getObjectByHeapObjectId(
        self,
        params: "GetObjectByHeapObjectIdParameters",
        session_id: Optional[str] = None,
    ) -> "GetObjectByHeapObjectIdReturns":
        return cast("GetObjectByHeapObjectIdReturns", await self._client.send_raw(
            method="HeapProfiler.getObjectByHeapObjectId",
            params=params,
            session_id=session_id,
        ))

    async def getSamplingProfile(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "GetSamplingProfileReturns":
        return cast("GetSamplingProfileReturns", await self._client.send_raw(
            method="HeapProfiler.getSamplingProfile",
            params=params,
            session_id=session_id,
        ))

    async def startSampling(
        self,
        params: Optional["StartSamplingParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="HeapProfiler.startSampling",
            params=params,
            session_id=session_id,
        ))

    async def startTrackingHeapObjects(
        self,
        params: Optional["StartTrackingHeapObjectsParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="HeapProfiler.startTrackingHeapObjects",
            params=params,
            session_id=session_id,
        ))

    async def stopSampling(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "StopSamplingReturns":
        return cast("StopSamplingReturns", await self._client.send_raw(
            method="HeapProfiler.stopSampling",
            params=params,
            session_id=session_id,
        ))

    async def stopTrackingHeapObjects(
        self,
        params: Optional["StopTrackingHeapObjectsParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="HeapProfiler.stopTrackingHeapObjects",
            params=params,
            session_id=session_id,
        ))

    async def takeHeapSnapshot(
        self,
        params: Optional["TakeHeapSnapshotParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="HeapProfiler.takeHeapSnapshot",
            params=params,
            session_id=session_id,
        ))


