# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Fetch Domain Events"""

from typing import List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..network.types import ErrorReason
    from ..network.types import Request
    from ..network.types import RequestId
    from ..network.types import ResourceType
    from ..page.types import FrameId
    from .types import AuthChallenge
    from .types import HeaderEntry
    from .types import RequestId

"""Issued when the domain is enabled and the request URL matches the
specified filter. The request is paused until the client responds
with one of continueRequest, failRequest or fulfillRequest.
The stage of the request can be determined by presence of responseErrorReason
and responseStatusCode -- the request is at the response stage if either
of these fields is present and in the request stage otherwise.
Redirect responses and subsequent requests are reported similarly to regular
responses and requests. Redirect responses may be distinguished by the value
of `responseStatusCode` (which is one of 301, 302, 303, 307, 308) along with
presence of the `location` header. Requests resulting from a redirect will
have `redirectedRequestId` field set."""
class RequestPausedEvent(TypedDict):
    requestId: "RequestId"
    """Each request the page makes will have a unique id."""
    request: "Request"
    """The details of the request."""
    frameId: "FrameId"
    """The id of the frame that initiated the request."""
    resourceType: "ResourceType"
    """How the requested resource will be used."""
    responseErrorReason: "NotRequired[ErrorReason]"
    """Response error if intercepted at response stage."""
    responseStatusCode: "NotRequired[int]"
    """Response code if intercepted at response stage."""
    responseStatusText: "NotRequired[str]"
    """Response status text if intercepted at response stage."""
    responseHeaders: "NotRequired[List[HeaderEntry]]"
    """Response headers if intercepted at the response stage."""
    networkId: "NotRequired[RequestId]"
    """If the intercepted request had a corresponding Network.requestWillBeSent event fired for it,
then this networkId will be the same as the requestId present in the requestWillBeSent event."""
    redirectedRequestId: "NotRequired[RequestId]"
    """If the request is due to a redirect response from the server, the id of the request that
has caused the redirect."""



"""Issued when the domain is enabled with handleAuthRequests set to true.
The request is paused until client responds with continueWithAuth."""
class AuthRequiredEvent(TypedDict):
    requestId: "RequestId"
    """Each request the page makes will have a unique id."""
    request: "Request"
    """The details of the request."""
    frameId: "FrameId"
    """The id of the frame that initiated the request."""
    resourceType: "ResourceType"
    """How the requested resource will be used."""
    authChallenge: "AuthChallenge"
    """Details of the Authorization Challenge encountered.
If this is set, client should respond with continueRequest that
contains AuthChallengeResponse."""
