# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Fetch Domain Commands"""

from typing import List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..io.types import StreamHandle
    from ..network.types import ErrorReason
    from .types import AuthChallengeResponse
    from .types import HeaderEntry
    from .types import RequestId
    from .types import RequestPattern

class EnableParameters(TypedDict, total=False):
    patterns: "List[RequestPattern]"
    """If specified, only requests matching any of these patterns will produce
fetchRequested event and will be paused until clients response. If not set,
all requests will be affected."""
    handleAuthRequests: "bool"
    """If true, authRequired events will be issued and requests will be paused
expecting a call to continueWithAuth."""





class FailRequestParameters(TypedDict):
    requestId: "RequestId"
    """An id the client received in requestPaused event."""
    errorReason: "ErrorReason"
    """Causes the request to fail with the given reason."""





class FulfillRequestParameters(TypedDict):
    requestId: "RequestId"
    """An id the client received in requestPaused event."""
    responseCode: "int"
    """An HTTP response code."""
    responseHeaders: "NotRequired[List[HeaderEntry]]"
    """Response headers."""
    binaryResponseHeaders: "NotRequired[str]"
    """Alternative way of specifying response headers as a \\0-separated
series of name: value pairs. Prefer the above method unless you
need to represent some non-UTF8 values that can't be transmitted
over the protocol as text. (Encoded as a base64 string when passed over JSON)"""
    body: "NotRequired[str]"
    """A response body. If absent, original response body will be used if
the request is intercepted at the response stage and empty body
will be used if the request is intercepted at the request stage. (Encoded as a base64 string when passed over JSON)"""
    responsePhrase: "NotRequired[str]"
    """A textual representation of responseCode.
If absent, a standard phrase matching responseCode is used."""





class ContinueRequestParameters(TypedDict):
    requestId: "RequestId"
    """An id the client received in requestPaused event."""
    url: "NotRequired[str]"
    """If set, the request url will be modified in a way that's not observable by page."""
    method: "NotRequired[str]"
    """If set, the request method is overridden."""
    postData: "NotRequired[str]"
    """If set, overrides the post data in the request. (Encoded as a base64 string when passed over JSON)"""
    headers: "NotRequired[List[HeaderEntry]]"
    """If set, overrides the request headers. Note that the overrides do not
extend to subsequent redirect hops, if a redirect happens. Another override
may be applied to a different request produced by a redirect."""
    interceptResponse: "NotRequired[bool]"
    """If set, overrides response interception behavior for this request."""





class ContinueWithAuthParameters(TypedDict):
    requestId: "RequestId"
    """An id the client received in authRequired event."""
    authChallengeResponse: "AuthChallengeResponse"
    """Response to  with an authChallenge."""





class ContinueResponseParameters(TypedDict):
    requestId: "RequestId"
    """An id the client received in requestPaused event."""
    responseCode: "NotRequired[int]"
    """An HTTP response code. If absent, original response code will be used."""
    responsePhrase: "NotRequired[str]"
    """A textual representation of responseCode.
If absent, a standard phrase matching responseCode is used."""
    responseHeaders: "NotRequired[List[HeaderEntry]]"
    """Response headers. If absent, original response headers will be used."""
    binaryResponseHeaders: "NotRequired[str]"
    """Alternative way of specifying response headers as a \\0-separated
series of name: value pairs. Prefer the above method unless you
need to represent some non-UTF8 values that can't be transmitted
over the protocol as text. (Encoded as a base64 string when passed over JSON)"""





class GetResponseBodyParameters(TypedDict):
    requestId: "RequestId"
    """Identifier for the intercepted request to get body for."""


class GetResponseBodyReturns(TypedDict):
    body: "str"
    """Response body."""
    base64Encoded: "bool"
    """True, if content was sent as base64."""



class TakeResponseBodyAsStreamParameters(TypedDict):
    requestId: "RequestId"


class TakeResponseBodyAsStreamReturns(TypedDict):
    stream: "StreamHandle"
