# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Emulation Domain Types"""

from typing import List
from typing_extensions import Literal
from typing_extensions import NotRequired, TypedDict

class SafeAreaInsets(TypedDict, total=False):
    top: "int"
    """Overrides safe-area-inset-top."""
    topMax: "int"
    """Overrides safe-area-max-inset-top."""
    left: "int"
    """Overrides safe-area-inset-left."""
    leftMax: "int"
    """Overrides safe-area-max-inset-left."""
    bottom: "int"
    """Overrides safe-area-inset-bottom."""
    bottomMax: "int"
    """Overrides safe-area-max-inset-bottom."""
    right: "int"
    """Overrides safe-area-inset-right."""
    rightMax: "int"
    """Overrides safe-area-max-inset-right."""



class ScreenOrientation(TypedDict):
    """Screen orientation."""

    type: "str"
    """Orientation type."""
    angle: "int"
    """Orientation angle."""



class DisplayFeature(TypedDict):
    orientation: "str"
    """Orientation of a display feature in relation to screen"""
    offset: "int"
    """The offset from the screen origin in either the x (for vertical
orientation) or y (for horizontal orientation) direction."""
    maskLength: "int"
    """A display feature may mask content such that it is not physically
displayed - this length along with the offset describes this area.
A display feature that only splits content will have a 0 mask_length."""



class DevicePosture(TypedDict):
    type: "str"
    """Current posture of the device"""



class MediaFeature(TypedDict):
    name: "str"
    value: "str"



VirtualTimePolicy = Literal["advance", "pause", "pauseIfNetworkFetchesPending"]
"""advance: If the scheduler runs out of immediate work, the virtual time base may fast forward to
allow the next delayed task (if any) to run; pause: The virtual time base may not advance;
pauseIfNetworkFetchesPending: The virtual time base may not advance if there are any pending
resource fetches."""



class UserAgentBrandVersion(TypedDict):
    """Used to specify User Agent Client Hints to emulate. See https://wicg.github.io/ua-client-hints"""

    brand: "str"
    version: "str"



class UserAgentMetadata(TypedDict):
    """Used to specify User Agent Client Hints to emulate. See https://wicg.github.io/ua-client-hints
Missing optional values will be filled in by the target with what it would normally use."""

    brands: "NotRequired[List[UserAgentBrandVersion]]"
    """Brands appearing in Sec-CH-UA."""
    fullVersionList: "NotRequired[List[UserAgentBrandVersion]]"
    """Brands appearing in Sec-CH-UA-Full-Version-List."""
    fullVersion: "NotRequired[str]"
    platform: "str"
    platformVersion: "str"
    architecture: "str"
    model: "str"
    mobile: "bool"
    bitness: "NotRequired[str]"
    wow64: "NotRequired[bool]"
    formFactors: "NotRequired[List[str]]"
    """Used to specify User Agent form-factor values.
See https://wicg.github.io/ua-client-hints/#sec-ch-ua-form-factors"""



SensorType = Literal["absolute-orientation", "accelerometer", "ambient-light", "gravity", "gyroscope", "linear-acceleration", "magnetometer", "relative-orientation"]
"""Used to specify sensor types to emulate.
See https://w3c.github.io/sensors/#automation for more information."""



class SensorMetadata(TypedDict, total=False):
    available: "bool"
    minimumFrequency: "float"
    maximumFrequency: "float"



class SensorReadingSingle(TypedDict):
    value: "float"



class SensorReadingXYZ(TypedDict):
    x: "float"
    y: "float"
    z: "float"



class SensorReadingQuaternion(TypedDict):
    x: "float"
    y: "float"
    z: "float"
    w: "float"



class SensorReading(TypedDict, total=False):
    single: "SensorReadingSingle"
    xyz: "SensorReadingXYZ"
    quaternion: "SensorReadingQuaternion"



PressureSource = Literal["cpu"]



PressureState = Literal["nominal", "fair", "serious", "critical"]



class PressureMetadata(TypedDict, total=False):
    available: "bool"



DisabledImageType = Literal["avif", "webp"]
"""Enum of image types that can be disabled."""
