# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP DOMSnapshot Domain Types"""

from typing import List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..dom.types import BackendNodeId
    from ..dom.types import PseudoType
    from ..dom.types import Rect
    from ..dom.types import ShadowRootType
    from ..domdebugger.types import EventListener
    from ..page.types import FrameId

class DOMNode(TypedDict):
    """A Node in the DOM tree."""

    nodeType: "int"
    """`Node`'s nodeType."""
    nodeName: "str"
    """`Node`'s nodeName."""
    nodeValue: "str"
    """`Node`'s nodeValue."""
    textValue: "NotRequired[str]"
    """Only set for textarea elements, contains the text value."""
    inputValue: "NotRequired[str]"
    """Only set for input elements, contains the input's associated text value."""
    inputChecked: "NotRequired[bool]"
    """Only set for radio and checkbox input elements, indicates if the element has been checked"""
    optionSelected: "NotRequired[bool]"
    """Only set for option elements, indicates if the element has been selected"""
    backendNodeId: "BackendNodeId"
    """`Node`'s id, corresponds to DOM.Node.backendNodeId."""
    childNodeIndexes: "NotRequired[List[int]]"
    """The indexes of the node's child nodes in the `domNodes` array returned by `getSnapshot`, if
any."""
    attributes: "NotRequired[List[NameValue]]"
    """Attributes of an `Element` node."""
    pseudoElementIndexes: "NotRequired[List[int]]"
    """Indexes of pseudo elements associated with this node in the `domNodes` array returned by
`getSnapshot`, if any."""
    layoutNodeIndex: "NotRequired[int]"
    """The index of the node's related layout tree node in the `layoutTreeNodes` array returned by
`getSnapshot`, if any."""
    documentURL: "NotRequired[str]"
    """Document URL that `Document` or `FrameOwner` node points to."""
    baseURL: "NotRequired[str]"
    """Base URL that `Document` or `FrameOwner` node uses for URL completion."""
    contentLanguage: "NotRequired[str]"
    """Only set for documents, contains the document's content language."""
    documentEncoding: "NotRequired[str]"
    """Only set for documents, contains the document's character set encoding."""
    publicId: "NotRequired[str]"
    """`DocumentType` node's publicId."""
    systemId: "NotRequired[str]"
    """`DocumentType` node's systemId."""
    frameId: "NotRequired[FrameId]"
    """Frame ID for frame owner elements and also for the document node."""
    contentDocumentIndex: "NotRequired[int]"
    """The index of a frame owner element's content document in the `domNodes` array returned by
`getSnapshot`, if any."""
    pseudoType: "NotRequired[PseudoType]"
    """Type of a pseudo element node."""
    shadowRootType: "NotRequired[ShadowRootType]"
    """Shadow root type."""
    isClickable: "NotRequired[bool]"
    """Whether this DOM node responds to mouse clicks. This includes nodes that have had click
event listeners attached via JavaScript as well as anchor tags that naturally navigate when
clicked."""
    eventListeners: "NotRequired[List[EventListener]]"
    """Details of the node's event listeners, if any."""
    currentSourceURL: "NotRequired[str]"
    """The selected url for nodes with a srcset attribute."""
    originURL: "NotRequired[str]"
    """The url of the script (if any) that generates this node."""
    scrollOffsetX: "NotRequired[float]"
    """Scroll offsets, set when this node is a Document."""
    scrollOffsetY: "NotRequired[float]"



class InlineTextBox(TypedDict):
    """Details of post layout rendered text positions. The exact layout should not be regarded as
stable and may change between versions."""

    boundingBox: "Rect"
    """The bounding box in document coordinates. Note that scroll offset of the document is ignored."""
    startCharacterIndex: "int"
    """The starting index in characters, for this post layout textbox substring. Characters that
would be represented as a surrogate pair in UTF-16 have length 2."""
    numCharacters: "int"
    """The number of characters in this post layout textbox substring. Characters that would be
represented as a surrogate pair in UTF-16 have length 2."""



class LayoutTreeNode(TypedDict):
    """Details of an element in the DOM tree with a LayoutObject."""

    domNodeIndex: "int"
    """The index of the related DOM node in the `domNodes` array returned by `getSnapshot`."""
    boundingBox: "Rect"
    """The bounding box in document coordinates. Note that scroll offset of the document is ignored."""
    layoutText: "NotRequired[str]"
    """Contents of the LayoutText, if any."""
    inlineTextNodes: "NotRequired[List[InlineTextBox]]"
    """The post-layout inline text nodes, if any."""
    styleIndex: "NotRequired[int]"
    """Index into the `computedStyles` array returned by `getSnapshot`."""
    paintOrder: "NotRequired[int]"
    """Global paint order index, which is determined by the stacking order of the nodes. Nodes
that are painted together will have the same index. Only provided if includePaintOrder in
getSnapshot was true."""
    isStackingContext: "NotRequired[bool]"
    """Set to true to indicate the element begins a new stacking context."""



class ComputedStyle(TypedDict):
    """A subset of the full ComputedStyle as defined by the request whitelist."""

    properties: "List[NameValue]"
    """Name/value pairs of computed style properties."""



class NameValue(TypedDict):
    """A name/value pair."""

    name: "str"
    """Attribute/property name."""
    value: "str"
    """Attribute/property value."""



StringIndex = int
"""Index of the string in the strings table."""



ArrayOfStrings = List[StringIndex]
"""Index of the string in the strings table."""



class RareStringData(TypedDict):
    """Data that is only present on rare nodes."""

    index: "List[int]"
    value: "List[StringIndex]"



class RareBooleanData(TypedDict):
    index: "List[int]"



class RareIntegerData(TypedDict):
    index: "List[int]"
    value: "List[int]"



Rectangle = List[float]



class DocumentSnapshot(TypedDict):
    """Document snapshot."""

    documentURL: "StringIndex"
    """Document URL that `Document` or `FrameOwner` node points to."""
    title: "StringIndex"
    """Document title."""
    baseURL: "StringIndex"
    """Base URL that `Document` or `FrameOwner` node uses for URL completion."""
    contentLanguage: "StringIndex"
    """Contains the document's content language."""
    encodingName: "StringIndex"
    """Contains the document's character set encoding."""
    publicId: "StringIndex"
    """`DocumentType` node's publicId."""
    systemId: "StringIndex"
    """`DocumentType` node's systemId."""
    frameId: "StringIndex"
    """Frame ID for frame owner elements and also for the document node."""
    nodes: "NodeTreeSnapshot"
    """A table with dom nodes."""
    layout: "LayoutTreeSnapshot"
    """The nodes in the layout tree."""
    textBoxes: "TextBoxSnapshot"
    """The post-layout inline text nodes."""
    scrollOffsetX: "NotRequired[float]"
    """Horizontal scroll offset."""
    scrollOffsetY: "NotRequired[float]"
    """Vertical scroll offset."""
    contentWidth: "NotRequired[float]"
    """Document content width."""
    contentHeight: "NotRequired[float]"
    """Document content height."""



class NodeTreeSnapshot(TypedDict, total=False):
    """Table containing nodes."""

    parentIndex: "List[int]"
    """Parent node index."""
    nodeType: "List[int]"
    """`Node`'s nodeType."""
    shadowRootType: "RareStringData"
    """Type of the shadow root the `Node` is in. String values are equal to the `ShadowRootType` enum."""
    nodeName: "List[StringIndex]"
    """`Node`'s nodeName."""
    nodeValue: "List[StringIndex]"
    """`Node`'s nodeValue."""
    backendNodeId: "List[BackendNodeId]"
    """`Node`'s id, corresponds to DOM.Node.backendNodeId."""
    attributes: "List[ArrayOfStrings]"
    """Attributes of an `Element` node. Flatten name, value pairs."""
    textValue: "RareStringData"
    """Only set for textarea elements, contains the text value."""
    inputValue: "RareStringData"
    """Only set for input elements, contains the input's associated text value."""
    inputChecked: "RareBooleanData"
    """Only set for radio and checkbox input elements, indicates if the element has been checked"""
    optionSelected: "RareBooleanData"
    """Only set for option elements, indicates if the element has been selected"""
    contentDocumentIndex: "RareIntegerData"
    """The index of the document in the list of the snapshot documents."""
    pseudoType: "RareStringData"
    """Type of a pseudo element node."""
    pseudoIdentifier: "RareStringData"
    """Pseudo element identifier for this node. Only present if there is a
valid pseudoType."""
    isClickable: "RareBooleanData"
    """Whether this DOM node responds to mouse clicks. This includes nodes that have had click
event listeners attached via JavaScript as well as anchor tags that naturally navigate when
clicked."""
    currentSourceURL: "RareStringData"
    """The selected url for nodes with a srcset attribute."""
    originURL: "RareStringData"
    """The url of the script (if any) that generates this node."""



class LayoutTreeSnapshot(TypedDict):
    """Table of details of an element in the DOM tree with a LayoutObject."""

    nodeIndex: "List[int]"
    """Index of the corresponding node in the `NodeTreeSnapshot` array returned by `captureSnapshot`."""
    styles: "List[ArrayOfStrings]"
    """Array of indexes specifying computed style strings, filtered according to the `computedStyles` parameter passed to `captureSnapshot`."""
    bounds: "List[Rectangle]"
    """The absolute position bounding box."""
    text: "List[StringIndex]"
    """Contents of the LayoutText, if any."""
    stackingContexts: "RareBooleanData"
    """Stacking context information."""
    paintOrders: "NotRequired[List[int]]"
    """Global paint order index, which is determined by the stacking order of the nodes. Nodes
that are painted together will have the same index. Only provided if includePaintOrder in
captureSnapshot was true."""
    offsetRects: "NotRequired[List[Rectangle]]"
    """The offset rect of nodes. Only available when includeDOMRects is set to true"""
    scrollRects: "NotRequired[List[Rectangle]]"
    """The scroll rect of nodes. Only available when includeDOMRects is set to true"""
    clientRects: "NotRequired[List[Rectangle]]"
    """The client rect of nodes. Only available when includeDOMRects is set to true"""
    blendedBackgroundColors: "NotRequired[List[StringIndex]]"
    """The list of background colors that are blended with colors of overlapping elements."""
    textColorOpacities: "NotRequired[List[float]]"
    """The list of computed text opacities."""



class TextBoxSnapshot(TypedDict):
    """Table of details of the post layout rendered text positions. The exact layout should not be regarded as
stable and may change between versions."""

    layoutIndex: "List[int]"
    """Index of the layout tree node that owns this box collection."""
    bounds: "List[Rectangle]"
    """The absolute position bounding box."""
    start: "List[int]"
    """The starting index in characters, for this post layout textbox substring. Characters that
would be represented as a surrogate pair in UTF-16 have length 2."""
    length: "List[int]"
    """The number of characters in this post layout textbox substring. Characters that would be
represented as a surrogate pair in UTF-16 have length 2."""
