# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP DOM Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import CollectClassNamesFromSubtreeParameters
    from .commands import CollectClassNamesFromSubtreeReturns
    from .commands import CopyToParameters
    from .commands import CopyToReturns
    from .commands import DescribeNodeParameters
    from .commands import DescribeNodeReturns
    from .commands import DiscardSearchResultsParameters
    from .commands import EnableParameters
    from .commands import FocusParameters
    from .commands import GetAnchorElementParameters
    from .commands import GetAnchorElementReturns
    from .commands import GetAttributesParameters
    from .commands import GetAttributesReturns
    from .commands import GetBoxModelParameters
    from .commands import GetBoxModelReturns
    from .commands import GetContainerForNodeParameters
    from .commands import GetContainerForNodeReturns
    from .commands import GetContentQuadsParameters
    from .commands import GetContentQuadsReturns
    from .commands import GetDetachedDomNodesReturns
    from .commands import GetDocumentParameters
    from .commands import GetDocumentReturns
    from .commands import GetElementByRelationParameters
    from .commands import GetElementByRelationReturns
    from .commands import GetFileInfoParameters
    from .commands import GetFileInfoReturns
    from .commands import GetFlattenedDocumentParameters
    from .commands import GetFlattenedDocumentReturns
    from .commands import GetFrameOwnerParameters
    from .commands import GetFrameOwnerReturns
    from .commands import GetNodeForLocationParameters
    from .commands import GetNodeForLocationReturns
    from .commands import GetNodeStackTracesParameters
    from .commands import GetNodeStackTracesReturns
    from .commands import GetNodesForSubtreeByStyleParameters
    from .commands import GetNodesForSubtreeByStyleReturns
    from .commands import GetOuterHTMLParameters
    from .commands import GetOuterHTMLReturns
    from .commands import GetQueryingDescendantsForContainerParameters
    from .commands import GetQueryingDescendantsForContainerReturns
    from .commands import GetRelayoutBoundaryParameters
    from .commands import GetRelayoutBoundaryReturns
    from .commands import GetSearchResultsParameters
    from .commands import GetSearchResultsReturns
    from .commands import GetTopLayerElementsReturns
    from .commands import MoveToParameters
    from .commands import MoveToReturns
    from .commands import PerformSearchParameters
    from .commands import PerformSearchReturns
    from .commands import PushNodeByPathToFrontendParameters
    from .commands import PushNodeByPathToFrontendReturns
    from .commands import PushNodesByBackendIdsToFrontendParameters
    from .commands import PushNodesByBackendIdsToFrontendReturns
    from .commands import QuerySelectorAllParameters
    from .commands import QuerySelectorAllReturns
    from .commands import QuerySelectorParameters
    from .commands import QuerySelectorReturns
    from .commands import RemoveAttributeParameters
    from .commands import RemoveNodeParameters
    from .commands import RequestChildNodesParameters
    from .commands import RequestNodeParameters
    from .commands import RequestNodeReturns
    from .commands import ResolveNodeParameters
    from .commands import ResolveNodeReturns
    from .commands import ScrollIntoViewIfNeededParameters
    from .commands import SetAttributeValueParameters
    from .commands import SetAttributesAsTextParameters
    from .commands import SetFileInputFilesParameters
    from .commands import SetInspectedNodeParameters
    from .commands import SetNodeNameParameters
    from .commands import SetNodeNameReturns
    from .commands import SetNodeStackTracesEnabledParameters
    from .commands import SetNodeValueParameters
    from .commands import SetOuterHTMLParameters

class DOMClient:
    """Client for DOM domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def collectClassNamesFromSubtree(
        self,
        params: "CollectClassNamesFromSubtreeParameters",
        session_id: Optional[str] = None,
    ) -> "CollectClassNamesFromSubtreeReturns":
        """Collects class names for the node with given id and all of it's child nodes."""
        return cast("CollectClassNamesFromSubtreeReturns", await self._client.send_raw(
            method="DOM.collectClassNamesFromSubtree",
            params=params,
            session_id=session_id,
        ))

    async def copyTo(
        self,
        params: "CopyToParameters",
        session_id: Optional[str] = None,
    ) -> "CopyToReturns":
        """Creates a deep copy of the specified node and places it into the target container before the
given anchor."""
        return cast("CopyToReturns", await self._client.send_raw(
            method="DOM.copyTo",
            params=params,
            session_id=session_id,
        ))

    async def describeNode(
        self,
        params: Optional["DescribeNodeParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "DescribeNodeReturns":
        """Describes node given its id, does not require domain to be enabled. Does not start tracking any
objects, can be used for automation."""
        return cast("DescribeNodeReturns", await self._client.send_raw(
            method="DOM.describeNode",
            params=params,
            session_id=session_id,
        ))

    async def scrollIntoViewIfNeeded(
        self,
        params: Optional["ScrollIntoViewIfNeededParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Scrolls the specified rect of the given node into view if not already visible.
Note: exactly one between nodeId, backendNodeId and objectId should be passed
to identify the node."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.scrollIntoViewIfNeeded",
            params=params,
            session_id=session_id,
        ))

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disables DOM agent for the given page."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.disable",
            params=params,
            session_id=session_id,
        ))

    async def discardSearchResults(
        self,
        params: "DiscardSearchResultsParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Discards search results from the session with the given id. `getSearchResults` should no longer
be called for that search."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.discardSearchResults",
            params=params,
            session_id=session_id,
        ))

    async def enable(
        self,
        params: Optional["EnableParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables DOM agent for the given page."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.enable",
            params=params,
            session_id=session_id,
        ))

    async def focus(
        self,
        params: Optional["FocusParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Focuses the given element."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.focus",
            params=params,
            session_id=session_id,
        ))

    async def getAttributes(
        self,
        params: "GetAttributesParameters",
        session_id: Optional[str] = None,
    ) -> "GetAttributesReturns":
        """Returns attributes for the specified node."""
        return cast("GetAttributesReturns", await self._client.send_raw(
            method="DOM.getAttributes",
            params=params,
            session_id=session_id,
        ))

    async def getBoxModel(
        self,
        params: Optional["GetBoxModelParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "GetBoxModelReturns":
        """Returns boxes for the given node."""
        return cast("GetBoxModelReturns", await self._client.send_raw(
            method="DOM.getBoxModel",
            params=params,
            session_id=session_id,
        ))

    async def getContentQuads(
        self,
        params: Optional["GetContentQuadsParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "GetContentQuadsReturns":
        """Returns quads that describe node position on the page. This method
might return multiple quads for inline nodes."""
        return cast("GetContentQuadsReturns", await self._client.send_raw(
            method="DOM.getContentQuads",
            params=params,
            session_id=session_id,
        ))

    async def getDocument(
        self,
        params: Optional["GetDocumentParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "GetDocumentReturns":
        """Returns the root DOM node (and optionally the subtree) to the caller.
Implicitly enables the DOM domain events for the current target."""
        return cast("GetDocumentReturns", await self._client.send_raw(
            method="DOM.getDocument",
            params=params,
            session_id=session_id,
        ))

    async def getFlattenedDocument(
        self,
        params: Optional["GetFlattenedDocumentParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "GetFlattenedDocumentReturns":
        """Returns the root DOM node (and optionally the subtree) to the caller.
Deprecated, as it is not designed to work well with the rest of the DOM agent.
Use DOMSnapshot.captureSnapshot instead."""
        return cast("GetFlattenedDocumentReturns", await self._client.send_raw(
            method="DOM.getFlattenedDocument",
            params=params,
            session_id=session_id,
        ))

    async def getNodesForSubtreeByStyle(
        self,
        params: "GetNodesForSubtreeByStyleParameters",
        session_id: Optional[str] = None,
    ) -> "GetNodesForSubtreeByStyleReturns":
        """Finds nodes with a given computed style in a subtree."""
        return cast("GetNodesForSubtreeByStyleReturns", await self._client.send_raw(
            method="DOM.getNodesForSubtreeByStyle",
            params=params,
            session_id=session_id,
        ))

    async def getNodeForLocation(
        self,
        params: "GetNodeForLocationParameters",
        session_id: Optional[str] = None,
    ) -> "GetNodeForLocationReturns":
        """Returns node id at given location. Depending on whether DOM domain is enabled, nodeId is
either returned or not."""
        return cast("GetNodeForLocationReturns", await self._client.send_raw(
            method="DOM.getNodeForLocation",
            params=params,
            session_id=session_id,
        ))

    async def getOuterHTML(
        self,
        params: Optional["GetOuterHTMLParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "GetOuterHTMLReturns":
        """Returns node's HTML markup."""
        return cast("GetOuterHTMLReturns", await self._client.send_raw(
            method="DOM.getOuterHTML",
            params=params,
            session_id=session_id,
        ))

    async def getRelayoutBoundary(
        self,
        params: "GetRelayoutBoundaryParameters",
        session_id: Optional[str] = None,
    ) -> "GetRelayoutBoundaryReturns":
        """Returns the id of the nearest ancestor that is a relayout boundary."""
        return cast("GetRelayoutBoundaryReturns", await self._client.send_raw(
            method="DOM.getRelayoutBoundary",
            params=params,
            session_id=session_id,
        ))

    async def getSearchResults(
        self,
        params: "GetSearchResultsParameters",
        session_id: Optional[str] = None,
    ) -> "GetSearchResultsReturns":
        """Returns search results from given `fromIndex` to given `toIndex` from the search with the given
identifier."""
        return cast("GetSearchResultsReturns", await self._client.send_raw(
            method="DOM.getSearchResults",
            params=params,
            session_id=session_id,
        ))

    async def hideHighlight(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Hides any highlight."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.hideHighlight",
            params=params,
            session_id=session_id,
        ))

    async def highlightNode(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Highlights DOM node."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.highlightNode",
            params=params,
            session_id=session_id,
        ))

    async def highlightRect(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Highlights given rectangle."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.highlightRect",
            params=params,
            session_id=session_id,
        ))

    async def markUndoableState(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Marks last undoable state."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.markUndoableState",
            params=params,
            session_id=session_id,
        ))

    async def moveTo(
        self,
        params: "MoveToParameters",
        session_id: Optional[str] = None,
    ) -> "MoveToReturns":
        """Moves node into the new container, places it before the given anchor."""
        return cast("MoveToReturns", await self._client.send_raw(
            method="DOM.moveTo",
            params=params,
            session_id=session_id,
        ))

    async def performSearch(
        self,
        params: "PerformSearchParameters",
        session_id: Optional[str] = None,
    ) -> "PerformSearchReturns":
        """Searches for a given string in the DOM tree. Use `getSearchResults` to access search results or
`cancelSearch` to end this search session."""
        return cast("PerformSearchReturns", await self._client.send_raw(
            method="DOM.performSearch",
            params=params,
            session_id=session_id,
        ))

    async def pushNodeByPathToFrontend(
        self,
        params: "PushNodeByPathToFrontendParameters",
        session_id: Optional[str] = None,
    ) -> "PushNodeByPathToFrontendReturns":
        """Requests that the node is sent to the caller given its path. // FIXME, use XPath"""
        return cast("PushNodeByPathToFrontendReturns", await self._client.send_raw(
            method="DOM.pushNodeByPathToFrontend",
            params=params,
            session_id=session_id,
        ))

    async def pushNodesByBackendIdsToFrontend(
        self,
        params: "PushNodesByBackendIdsToFrontendParameters",
        session_id: Optional[str] = None,
    ) -> "PushNodesByBackendIdsToFrontendReturns":
        """Requests that a batch of nodes is sent to the caller given their backend node ids."""
        return cast("PushNodesByBackendIdsToFrontendReturns", await self._client.send_raw(
            method="DOM.pushNodesByBackendIdsToFrontend",
            params=params,
            session_id=session_id,
        ))

    async def querySelector(
        self,
        params: "QuerySelectorParameters",
        session_id: Optional[str] = None,
    ) -> "QuerySelectorReturns":
        """Executes `querySelector` on a given node."""
        return cast("QuerySelectorReturns", await self._client.send_raw(
            method="DOM.querySelector",
            params=params,
            session_id=session_id,
        ))

    async def querySelectorAll(
        self,
        params: "QuerySelectorAllParameters",
        session_id: Optional[str] = None,
    ) -> "QuerySelectorAllReturns":
        """Executes `querySelectorAll` on a given node."""
        return cast("QuerySelectorAllReturns", await self._client.send_raw(
            method="DOM.querySelectorAll",
            params=params,
            session_id=session_id,
        ))

    async def getTopLayerElements(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "GetTopLayerElementsReturns":
        """Returns NodeIds of current top layer elements.
Top layer is rendered closest to the user within a viewport, therefore its elements always
appear on top of all other content."""
        return cast("GetTopLayerElementsReturns", await self._client.send_raw(
            method="DOM.getTopLayerElements",
            params=params,
            session_id=session_id,
        ))

    async def getElementByRelation(
        self,
        params: "GetElementByRelationParameters",
        session_id: Optional[str] = None,
    ) -> "GetElementByRelationReturns":
        """Returns the NodeId of the matched element according to certain relations."""
        return cast("GetElementByRelationReturns", await self._client.send_raw(
            method="DOM.getElementByRelation",
            params=params,
            session_id=session_id,
        ))

    async def redo(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Re-does the last undone action."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.redo",
            params=params,
            session_id=session_id,
        ))

    async def removeAttribute(
        self,
        params: "RemoveAttributeParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Removes attribute with given name from an element with given id."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.removeAttribute",
            params=params,
            session_id=session_id,
        ))

    async def removeNode(
        self,
        params: "RemoveNodeParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Removes node with given id."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.removeNode",
            params=params,
            session_id=session_id,
        ))

    async def requestChildNodes(
        self,
        params: "RequestChildNodesParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Requests that children of the node with given id are returned to the caller in form of
`setChildNodes` events where not only immediate children are retrieved, but all children down to
the specified depth."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.requestChildNodes",
            params=params,
            session_id=session_id,
        ))

    async def requestNode(
        self,
        params: "RequestNodeParameters",
        session_id: Optional[str] = None,
    ) -> "RequestNodeReturns":
        """Requests that the node is sent to the caller given the JavaScript node object reference. All
nodes that form the path from the node to the root are also sent to the client as a series of
`setChildNodes` notifications."""
        return cast("RequestNodeReturns", await self._client.send_raw(
            method="DOM.requestNode",
            params=params,
            session_id=session_id,
        ))

    async def resolveNode(
        self,
        params: Optional["ResolveNodeParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "ResolveNodeReturns":
        """Resolves the JavaScript node object for a given NodeId or BackendNodeId."""
        return cast("ResolveNodeReturns", await self._client.send_raw(
            method="DOM.resolveNode",
            params=params,
            session_id=session_id,
        ))

    async def setAttributeValue(
        self,
        params: "SetAttributeValueParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Sets attribute for an element with given id."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.setAttributeValue",
            params=params,
            session_id=session_id,
        ))

    async def setAttributesAsText(
        self,
        params: "SetAttributesAsTextParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Sets attributes on element with given id. This method is useful when user edits some existing
attribute value and types in several attribute name/value pairs."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.setAttributesAsText",
            params=params,
            session_id=session_id,
        ))

    async def setFileInputFiles(
        self,
        params: "SetFileInputFilesParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Sets files for the given file input element."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.setFileInputFiles",
            params=params,
            session_id=session_id,
        ))

    async def setNodeStackTracesEnabled(
        self,
        params: "SetNodeStackTracesEnabledParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Sets if stack traces should be captured for Nodes. See `Node.getNodeStackTraces`. Default is disabled."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.setNodeStackTracesEnabled",
            params=params,
            session_id=session_id,
        ))

    async def getNodeStackTraces(
        self,
        params: "GetNodeStackTracesParameters",
        session_id: Optional[str] = None,
    ) -> "GetNodeStackTracesReturns":
        """Gets stack traces associated with a Node. As of now, only provides stack trace for Node creation."""
        return cast("GetNodeStackTracesReturns", await self._client.send_raw(
            method="DOM.getNodeStackTraces",
            params=params,
            session_id=session_id,
        ))

    async def getFileInfo(
        self,
        params: "GetFileInfoParameters",
        session_id: Optional[str] = None,
    ) -> "GetFileInfoReturns":
        """Returns file information for the given
File wrapper."""
        return cast("GetFileInfoReturns", await self._client.send_raw(
            method="DOM.getFileInfo",
            params=params,
            session_id=session_id,
        ))

    async def getDetachedDomNodes(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "GetDetachedDomNodesReturns":
        """Returns list of detached nodes"""
        return cast("GetDetachedDomNodesReturns", await self._client.send_raw(
            method="DOM.getDetachedDomNodes",
            params=params,
            session_id=session_id,
        ))

    async def setInspectedNode(
        self,
        params: "SetInspectedNodeParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables console to refer to the node with given id via $x (see Command Line API for more details
$x functions)."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.setInspectedNode",
            params=params,
            session_id=session_id,
        ))

    async def setNodeName(
        self,
        params: "SetNodeNameParameters",
        session_id: Optional[str] = None,
    ) -> "SetNodeNameReturns":
        """Sets node name for a node with given id."""
        return cast("SetNodeNameReturns", await self._client.send_raw(
            method="DOM.setNodeName",
            params=params,
            session_id=session_id,
        ))

    async def setNodeValue(
        self,
        params: "SetNodeValueParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Sets node value for a node with given id."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.setNodeValue",
            params=params,
            session_id=session_id,
        ))

    async def setOuterHTML(
        self,
        params: "SetOuterHTMLParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Sets node HTML markup, returns new node id."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.setOuterHTML",
            params=params,
            session_id=session_id,
        ))

    async def undo(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Undoes the last performed action."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="DOM.undo",
            params=params,
            session_id=session_id,
        ))

    async def getFrameOwner(
        self,
        params: "GetFrameOwnerParameters",
        session_id: Optional[str] = None,
    ) -> "GetFrameOwnerReturns":
        """Returns iframe node that owns iframe with the given domain."""
        return cast("GetFrameOwnerReturns", await self._client.send_raw(
            method="DOM.getFrameOwner",
            params=params,
            session_id=session_id,
        ))

    async def getContainerForNode(
        self,
        params: "GetContainerForNodeParameters",
        session_id: Optional[str] = None,
    ) -> "GetContainerForNodeReturns":
        """Returns the query container of the given node based on container query
conditions: containerName, physical and logical axes, and whether it queries
scroll-state. If no axes are provided and queriesScrollState is false, the
style container is returned, which is the direct parent or the closest
element with a matching container-name."""
        return cast("GetContainerForNodeReturns", await self._client.send_raw(
            method="DOM.getContainerForNode",
            params=params,
            session_id=session_id,
        ))

    async def getQueryingDescendantsForContainer(
        self,
        params: "GetQueryingDescendantsForContainerParameters",
        session_id: Optional[str] = None,
    ) -> "GetQueryingDescendantsForContainerReturns":
        """Returns the descendants of a container query container that have
container queries against this container."""
        return cast("GetQueryingDescendantsForContainerReturns", await self._client.send_raw(
            method="DOM.getQueryingDescendantsForContainer",
            params=params,
            session_id=session_id,
        ))

    async def getAnchorElement(
        self,
        params: "GetAnchorElementParameters",
        session_id: Optional[str] = None,
    ) -> "GetAnchorElementReturns":
        """Returns the target anchor element of the given anchor query according to
https://www.w3.org/TR/css-anchor-position-1/#target."""
        return cast("GetAnchorElementReturns", await self._client.send_raw(
            method="DOM.getAnchorElement",
            params=params,
            session_id=session_id,
        ))


