# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP DOM Domain Events"""

from typing import List
from typing_extensions import TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..dom.types import NodeId
    from .types import BackendNode
    from .types import Node
    from .types import NodeId

"""Fired when `Element`'s attribute is modified."""
class AttributeModifiedEvent(TypedDict):
    nodeId: "NodeId"
    """Id of the node that has changed."""
    name: "str"
    """Attribute name."""
    value: "str"
    """Attribute value."""



"""Fired when `Element`'s attribute is removed."""
class AttributeRemovedEvent(TypedDict):
    nodeId: "NodeId"
    """Id of the node that has changed."""
    name: "str"
    """A ttribute name."""



"""Mirrors `DOMCharacterDataModified` event."""
class CharacterDataModifiedEvent(TypedDict):
    nodeId: "NodeId"
    """Id of the node that has changed."""
    characterData: "str"
    """New text value."""



"""Fired when `Container`'s child node count has changed."""
class ChildNodeCountUpdatedEvent(TypedDict):
    nodeId: "NodeId"
    """Id of the node that has changed."""
    childNodeCount: "int"
    """New node count."""



"""Mirrors `DOMNodeInserted` event."""
class ChildNodeInsertedEvent(TypedDict):
    parentNodeId: "NodeId"
    """Id of the node that has changed."""
    previousNodeId: "NodeId"
    """Id of the previous sibling."""
    node: "Node"
    """Inserted node data."""



"""Mirrors `DOMNodeRemoved` event."""
class ChildNodeRemovedEvent(TypedDict):
    parentNodeId: "NodeId"
    """Parent id."""
    nodeId: "NodeId"
    """Id of the node that has been removed."""



"""Called when distribution is changed."""
class DistributedNodesUpdatedEvent(TypedDict):
    insertionPointId: "NodeId"
    """Insertion point where distributed nodes were updated."""
    distributedNodes: "List[BackendNode]"
    """Distributed nodes for given insertion point."""



"""Fired when `Document` has been totally updated. Node ids are no longer valid."""
class DocumentUpdatedEvent(TypedDict):
    pass



"""Fired when `Element`'s inline style is modified via a CSS property modification."""
class InlineStyleInvalidatedEvent(TypedDict):
    nodeIds: "List[NodeId]"
    """Ids of the nodes for which the inline styles have been invalidated."""



"""Called when a pseudo element is added to an element."""
class PseudoElementAddedEvent(TypedDict):
    parentId: "NodeId"
    """Pseudo element's parent element id."""
    pseudoElement: "Node"
    """The added pseudo element."""



"""Called when top layer elements are changed."""
class TopLayerElementsUpdatedEvent(TypedDict):
    pass



"""Fired when a node's scrollability state changes."""
class ScrollableFlagUpdatedEvent(TypedDict):
    nodeId: "NodeId"
    """The id of the node."""
    isScrollable: "bool"
    """If the node is scrollable."""



"""Called when a pseudo element is removed from an element."""
class PseudoElementRemovedEvent(TypedDict):
    parentId: "NodeId"
    """Pseudo element's parent element id."""
    pseudoElementId: "NodeId"
    """The removed pseudo element id."""



"""Fired when backend wants to provide client with the missing DOM structure. This happens upon
most of the calls requesting node ids."""
class SetChildNodesEvent(TypedDict):
    parentId: "NodeId"
    """Parent node id to populate with children."""
    nodes: "List[Node]"
    """Child nodes array."""



"""Called when shadow root is popped from the element."""
class ShadowRootPoppedEvent(TypedDict):
    hostId: "NodeId"
    """Host element id."""
    rootId: "NodeId"
    """Shadow root id."""



"""Called when shadow root is pushed into the element."""
class ShadowRootPushedEvent(TypedDict):
    hostId: "NodeId"
    """Host element id."""
    root: "Node"
    """Shadow root."""
