# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Debugger Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import ContinueToLocationParameters
    from .commands import DisassembleWasmModuleParameters
    from .commands import DisassembleWasmModuleReturns
    from .commands import EnableParameters
    from .commands import EnableReturns
    from .commands import EvaluateOnCallFrameParameters
    from .commands import EvaluateOnCallFrameReturns
    from .commands import GetPossibleBreakpointsParameters
    from .commands import GetPossibleBreakpointsReturns
    from .commands import GetScriptSourceParameters
    from .commands import GetScriptSourceReturns
    from .commands import GetStackTraceParameters
    from .commands import GetStackTraceReturns
    from .commands import GetWasmBytecodeParameters
    from .commands import GetWasmBytecodeReturns
    from .commands import NextWasmDisassemblyChunkParameters
    from .commands import NextWasmDisassemblyChunkReturns
    from .commands import PauseOnAsyncCallParameters
    from .commands import RemoveBreakpointParameters
    from .commands import RestartFrameParameters
    from .commands import RestartFrameReturns
    from .commands import ResumeParameters
    from .commands import SearchInContentParameters
    from .commands import SearchInContentReturns
    from .commands import SetAsyncCallStackDepthParameters
    from .commands import SetBlackboxExecutionContextsParameters
    from .commands import SetBlackboxPatternsParameters
    from .commands import SetBlackboxedRangesParameters
    from .commands import SetBreakpointByUrlParameters
    from .commands import SetBreakpointByUrlReturns
    from .commands import SetBreakpointOnFunctionCallParameters
    from .commands import SetBreakpointOnFunctionCallReturns
    from .commands import SetBreakpointParameters
    from .commands import SetBreakpointReturns
    from .commands import SetBreakpointsActiveParameters
    from .commands import SetInstrumentationBreakpointParameters
    from .commands import SetInstrumentationBreakpointReturns
    from .commands import SetPauseOnExceptionsParameters
    from .commands import SetReturnValueParameters
    from .commands import SetScriptSourceParameters
    from .commands import SetScriptSourceReturns
    from .commands import SetSkipAllPausesParameters
    from .commands import SetVariableValueParameters
    from .commands import StepIntoParameters
    from .commands import StepOverParameters

class DebuggerClient:
    """Client for Debugger domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def continueToLocation(
        self,
        params: "ContinueToLocationParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Continues execution until specific location is reached."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.continueToLocation",
            params=params,
            session_id=session_id,
        ))

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disables debugger for given page."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.disable",
            params=params,
            session_id=session_id,
        ))

    async def enable(
        self,
        params: Optional["EnableParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "EnableReturns":
        """Enables debugger for the given page. Clients should not assume that the debugging has been
enabled until the result for this command is received."""
        return cast("EnableReturns", await self._client.send_raw(
            method="Debugger.enable",
            params=params,
            session_id=session_id,
        ))

    async def evaluateOnCallFrame(
        self,
        params: "EvaluateOnCallFrameParameters",
        session_id: Optional[str] = None,
    ) -> "EvaluateOnCallFrameReturns":
        """Evaluates expression on a given call frame."""
        return cast("EvaluateOnCallFrameReturns", await self._client.send_raw(
            method="Debugger.evaluateOnCallFrame",
            params=params,
            session_id=session_id,
        ))

    async def getPossibleBreakpoints(
        self,
        params: "GetPossibleBreakpointsParameters",
        session_id: Optional[str] = None,
    ) -> "GetPossibleBreakpointsReturns":
        """Returns possible locations for breakpoint. scriptId in start and end range locations should be
the same."""
        return cast("GetPossibleBreakpointsReturns", await self._client.send_raw(
            method="Debugger.getPossibleBreakpoints",
            params=params,
            session_id=session_id,
        ))

    async def getScriptSource(
        self,
        params: "GetScriptSourceParameters",
        session_id: Optional[str] = None,
    ) -> "GetScriptSourceReturns":
        """Returns source for the script with given id."""
        return cast("GetScriptSourceReturns", await self._client.send_raw(
            method="Debugger.getScriptSource",
            params=params,
            session_id=session_id,
        ))

    async def disassembleWasmModule(
        self,
        params: "DisassembleWasmModuleParameters",
        session_id: Optional[str] = None,
    ) -> "DisassembleWasmModuleReturns":
        return cast("DisassembleWasmModuleReturns", await self._client.send_raw(
            method="Debugger.disassembleWasmModule",
            params=params,
            session_id=session_id,
        ))

    async def nextWasmDisassemblyChunk(
        self,
        params: "NextWasmDisassemblyChunkParameters",
        session_id: Optional[str] = None,
    ) -> "NextWasmDisassemblyChunkReturns":
        """Disassemble the next chunk of lines for the module corresponding to the
stream. If disassembly is complete, this API will invalidate the streamId
and return an empty chunk. Any subsequent calls for the now invalid stream
will return errors."""
        return cast("NextWasmDisassemblyChunkReturns", await self._client.send_raw(
            method="Debugger.nextWasmDisassemblyChunk",
            params=params,
            session_id=session_id,
        ))

    async def getWasmBytecode(
        self,
        params: "GetWasmBytecodeParameters",
        session_id: Optional[str] = None,
    ) -> "GetWasmBytecodeReturns":
        """This command is deprecated. Use getScriptSource instead."""
        return cast("GetWasmBytecodeReturns", await self._client.send_raw(
            method="Debugger.getWasmBytecode",
            params=params,
            session_id=session_id,
        ))

    async def getStackTrace(
        self,
        params: "GetStackTraceParameters",
        session_id: Optional[str] = None,
    ) -> "GetStackTraceReturns":
        """Returns stack trace with given `stackTraceId`."""
        return cast("GetStackTraceReturns", await self._client.send_raw(
            method="Debugger.getStackTrace",
            params=params,
            session_id=session_id,
        ))

    async def pause(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Stops on the next JavaScript statement."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.pause",
            params=params,
            session_id=session_id,
        ))

    async def pauseOnAsyncCall(
        self,
        params: "PauseOnAsyncCallParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.pauseOnAsyncCall",
            params=params,
            session_id=session_id,
        ))

    async def removeBreakpoint(
        self,
        params: "RemoveBreakpointParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Removes JavaScript breakpoint."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.removeBreakpoint",
            params=params,
            session_id=session_id,
        ))

    async def restartFrame(
        self,
        params: "RestartFrameParameters",
        session_id: Optional[str] = None,
    ) -> "RestartFrameReturns":
        """Restarts particular call frame from the beginning. The old, deprecated
behavior of `restartFrame` is to stay paused and allow further CDP commands
after a restart was scheduled. This can cause problems with restarting, so
we now continue execution immediatly after it has been scheduled until we
reach the beginning of the restarted frame.

To stay back-wards compatible, `restartFrame` now expects a `mode`
parameter to be present. If the `mode` parameter is missing, `restartFrame`
errors out.

The various return values are deprecated and `callFrames` is always empty.
Use the call frames from the `Debugger#paused` events instead, that fires
once V8 pauses at the beginning of the restarted function."""
        return cast("RestartFrameReturns", await self._client.send_raw(
            method="Debugger.restartFrame",
            params=params,
            session_id=session_id,
        ))

    async def resume(
        self,
        params: Optional["ResumeParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Resumes JavaScript execution."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.resume",
            params=params,
            session_id=session_id,
        ))

    async def searchInContent(
        self,
        params: "SearchInContentParameters",
        session_id: Optional[str] = None,
    ) -> "SearchInContentReturns":
        """Searches for given string in script content."""
        return cast("SearchInContentReturns", await self._client.send_raw(
            method="Debugger.searchInContent",
            params=params,
            session_id=session_id,
        ))

    async def setAsyncCallStackDepth(
        self,
        params: "SetAsyncCallStackDepthParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables or disables async call stacks tracking."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.setAsyncCallStackDepth",
            params=params,
            session_id=session_id,
        ))

    async def setBlackboxExecutionContexts(
        self,
        params: "SetBlackboxExecutionContextsParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Replace previous blackbox execution contexts with passed ones. Forces backend to skip
stepping/pausing in scripts in these execution contexts. VM will try to leave blackboxed script by
performing 'step in' several times, finally resorting to 'step out' if unsuccessful."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.setBlackboxExecutionContexts",
            params=params,
            session_id=session_id,
        ))

    async def setBlackboxPatterns(
        self,
        params: "SetBlackboxPatternsParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Replace previous blackbox patterns with passed ones. Forces backend to skip stepping/pausing in
scripts with url matching one of the patterns. VM will try to leave blackboxed script by
performing 'step in' several times, finally resorting to 'step out' if unsuccessful."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.setBlackboxPatterns",
            params=params,
            session_id=session_id,
        ))

    async def setBlackboxedRanges(
        self,
        params: "SetBlackboxedRangesParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Makes backend skip steps in the script in blackboxed ranges. VM will try leave blacklisted
scripts by performing 'step in' several times, finally resorting to 'step out' if unsuccessful.
Positions array contains positions where blackbox state is changed. First interval isn't
blackboxed. Array should be sorted."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.setBlackboxedRanges",
            params=params,
            session_id=session_id,
        ))

    async def setBreakpoint(
        self,
        params: "SetBreakpointParameters",
        session_id: Optional[str] = None,
    ) -> "SetBreakpointReturns":
        """Sets JavaScript breakpoint at a given location."""
        return cast("SetBreakpointReturns", await self._client.send_raw(
            method="Debugger.setBreakpoint",
            params=params,
            session_id=session_id,
        ))

    async def setInstrumentationBreakpoint(
        self,
        params: "SetInstrumentationBreakpointParameters",
        session_id: Optional[str] = None,
    ) -> "SetInstrumentationBreakpointReturns":
        """Sets instrumentation breakpoint."""
        return cast("SetInstrumentationBreakpointReturns", await self._client.send_raw(
            method="Debugger.setInstrumentationBreakpoint",
            params=params,
            session_id=session_id,
        ))

    async def setBreakpointByUrl(
        self,
        params: "SetBreakpointByUrlParameters",
        session_id: Optional[str] = None,
    ) -> "SetBreakpointByUrlReturns":
        """Sets JavaScript breakpoint at given location specified either by URL or URL regex. Once this
command is issued, all existing parsed scripts will have breakpoints resolved and returned in
`locations` property. Further matching script parsing will result in subsequent
`breakpointResolved` events issued. This logical breakpoint will survive page reloads."""
        return cast("SetBreakpointByUrlReturns", await self._client.send_raw(
            method="Debugger.setBreakpointByUrl",
            params=params,
            session_id=session_id,
        ))

    async def setBreakpointOnFunctionCall(
        self,
        params: "SetBreakpointOnFunctionCallParameters",
        session_id: Optional[str] = None,
    ) -> "SetBreakpointOnFunctionCallReturns":
        """Sets JavaScript breakpoint before each call to the given function.
If another function was created from the same source as a given one,
calling it will also trigger the breakpoint."""
        return cast("SetBreakpointOnFunctionCallReturns", await self._client.send_raw(
            method="Debugger.setBreakpointOnFunctionCall",
            params=params,
            session_id=session_id,
        ))

    async def setBreakpointsActive(
        self,
        params: "SetBreakpointsActiveParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Activates / deactivates all breakpoints on the page."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.setBreakpointsActive",
            params=params,
            session_id=session_id,
        ))

    async def setPauseOnExceptions(
        self,
        params: "SetPauseOnExceptionsParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Defines pause on exceptions state. Can be set to stop on all exceptions, uncaught exceptions,
or caught exceptions, no exceptions. Initial pause on exceptions state is `none`."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.setPauseOnExceptions",
            params=params,
            session_id=session_id,
        ))

    async def setReturnValue(
        self,
        params: "SetReturnValueParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Changes return value in top frame. Available only at return break position."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.setReturnValue",
            params=params,
            session_id=session_id,
        ))

    async def setScriptSource(
        self,
        params: "SetScriptSourceParameters",
        session_id: Optional[str] = None,
    ) -> "SetScriptSourceReturns":
        """Edits JavaScript source live.

In general, functions that are currently on the stack can not be edited with
a single exception: If the edited function is the top-most stack frame and
that is the only activation of that function on the stack. In this case
the live edit will be successful and a `Debugger.restartFrame` for the
top-most function is automatically triggered."""
        return cast("SetScriptSourceReturns", await self._client.send_raw(
            method="Debugger.setScriptSource",
            params=params,
            session_id=session_id,
        ))

    async def setSkipAllPauses(
        self,
        params: "SetSkipAllPausesParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Makes page not interrupt on any pauses (breakpoint, exception, dom exception etc)."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.setSkipAllPauses",
            params=params,
            session_id=session_id,
        ))

    async def setVariableValue(
        self,
        params: "SetVariableValueParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Changes value of variable in a callframe. Object-based scopes are not supported and must be
mutated manually."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.setVariableValue",
            params=params,
            session_id=session_id,
        ))

    async def stepInto(
        self,
        params: Optional["StepIntoParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Steps into the function call."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.stepInto",
            params=params,
            session_id=session_id,
        ))

    async def stepOut(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Steps out of the function call."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.stepOut",
            params=params,
            session_id=session_id,
        ))

    async def stepOver(
        self,
        params: Optional["StepOverParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Steps over the statement."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="Debugger.stepOver",
            params=params,
            session_id=session_id,
        ))


