# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP CSS Domain Types"""

from typing import List
from typing_extensions import Literal
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..dom.types import BackendNodeId
    from ..dom.types import LogicalAxes
    from ..dom.types import PhysicalAxes
    from ..dom.types import PseudoType
    from ..page.types import FrameId

StyleSheetId = str



StyleSheetOrigin = Literal["injected", "user-agent", "inspector", "regular"]
"""Stylesheet type: "injected" for stylesheets injected via extension, "user-agent" for user-agent
stylesheets, "inspector" for stylesheets created by the inspector (i.e. those holding the "via
inspector" rules), "regular" for regular stylesheets."""



class PseudoElementMatches(TypedDict):
    """CSS rule collection for a single pseudo style."""

    pseudoType: "PseudoType"
    """Pseudo element type."""
    pseudoIdentifier: "NotRequired[str]"
    """Pseudo element custom ident."""
    matches: "List[RuleMatch]"
    """Matches of CSS rules applicable to the pseudo style."""



class CSSAnimationStyle(TypedDict):
    """CSS style coming from animations with the name of the animation."""

    name: "NotRequired[str]"
    """The name of the animation."""
    style: "CSSStyle"
    """The style coming from the animation."""



class InheritedStyleEntry(TypedDict):
    """Inherited CSS rule collection from ancestor node."""

    inlineStyle: "NotRequired[CSSStyle]"
    """The ancestor node's inline style, if any, in the style inheritance chain."""
    matchedCSSRules: "List[RuleMatch]"
    """Matches of CSS rules matching the ancestor node in the style inheritance chain."""



class InheritedAnimatedStyleEntry(TypedDict, total=False):
    """Inherited CSS style collection for animated styles from ancestor node."""

    animationStyles: "List[CSSAnimationStyle]"
    """Styles coming from the animations of the ancestor, if any, in the style inheritance chain."""
    transitionsStyle: "CSSStyle"
    """The style coming from the transitions of the ancestor, if any, in the style inheritance chain."""



class InheritedPseudoElementMatches(TypedDict):
    """Inherited pseudo element matches from pseudos of an ancestor node."""

    pseudoElements: "List[PseudoElementMatches]"
    """Matches of pseudo styles from the pseudos of an ancestor node."""



class RuleMatch(TypedDict):
    """Match data for a CSS rule."""

    rule: "CSSRule"
    """CSS rule in the match."""
    matchingSelectors: "List[int]"
    """Matching selector indices in the rule's selectorList selectors (0-based)."""



class Value(TypedDict):
    """Data for a simple selector (these are delimited by commas in a selector list)."""

    text: "str"
    """Value text."""
    range: "NotRequired[SourceRange]"
    """Value range in the underlying resource (if available)."""
    specificity: "NotRequired[Specificity]"
    """Specificity of the selector."""



class Specificity(TypedDict):
    """Specificity:
https://drafts.csswg.org/selectors/#specificity-rules"""

    a: "int"
    """The a component, which represents the number of ID selectors."""
    b: "int"
    """The b component, which represents the number of class selectors, attributes selectors, and
pseudo-classes."""
    c: "int"
    """The c component, which represents the number of type selectors and pseudo-elements."""



class SelectorList(TypedDict):
    """Selector list data."""

    selectors: "List[Value]"
    """Selectors in the list."""
    text: "str"
    """Rule selector text."""



class CSSStyleSheetHeader(TypedDict):
    """CSS stylesheet metainformation."""

    styleSheetId: "StyleSheetId"
    """The stylesheet identifier."""
    frameId: "FrameId"
    """Owner frame identifier."""
    sourceURL: "str"
    """Stylesheet resource URL. Empty if this is a constructed stylesheet created using
new CSSStyleSheet() (but non-empty if this is a constructed stylesheet imported
as a CSS module script)."""
    sourceMapURL: "NotRequired[str]"
    """URL of source map associated with the stylesheet (if any)."""
    origin: "StyleSheetOrigin"
    """Stylesheet origin."""
    title: "str"
    """Stylesheet title."""
    ownerNode: "NotRequired[BackendNodeId]"
    """The backend id for the owner node of the stylesheet."""
    disabled: "bool"
    """Denotes whether the stylesheet is disabled."""
    hasSourceURL: "NotRequired[bool]"
    """Whether the sourceURL field value comes from the sourceURL comment."""
    isInline: "bool"
    """Whether this stylesheet is created for STYLE tag by parser. This flag is not set for
document.written STYLE tags."""
    isMutable: "bool"
    """Whether this stylesheet is mutable. Inline stylesheets become mutable
after they have been modified via CSSOM API.
`<link>` element's stylesheets become mutable only if DevTools modifies them.
Constructed stylesheets (new CSSStyleSheet()) are mutable immediately after creation."""
    isConstructed: "bool"
    """True if this stylesheet is created through new CSSStyleSheet() or imported as a
CSS module script."""
    startLine: "float"
    """Line offset of the stylesheet within the resource (zero based)."""
    startColumn: "float"
    """Column offset of the stylesheet within the resource (zero based)."""
    length: "float"
    """Size of the content (in characters)."""
    endLine: "float"
    """Line offset of the end of the stylesheet within the resource (zero based)."""
    endColumn: "float"
    """Column offset of the end of the stylesheet within the resource (zero based)."""
    loadingFailed: "NotRequired[bool]"
    """If the style sheet was loaded from a network resource, this indicates when the resource failed to load"""



class CSSRule(TypedDict):
    """CSS rule representation."""

    styleSheetId: "NotRequired[StyleSheetId]"
    """The css style sheet identifier (absent for user agent stylesheet and user-specified
stylesheet rules) this rule came from."""
    selectorList: "SelectorList"
    """Rule selector data."""
    nestingSelectors: "NotRequired[List[str]]"
    """Array of selectors from ancestor style rules, sorted by distance from the current rule."""
    origin: "StyleSheetOrigin"
    """Parent stylesheet's origin."""
    style: "CSSStyle"
    """Associated style declaration."""
    media: "NotRequired[List[CSSMedia]]"
    """Media list array (for rules involving media queries). The array enumerates media queries
starting with the innermost one, going outwards."""
    containerQueries: "NotRequired[List[CSSContainerQuery]]"
    """Container query list array (for rules involving container queries).
The array enumerates container queries starting with the innermost one, going outwards."""
    supports: "NotRequired[List[CSSSupports]]"
    """@supports CSS at-rule array.
The array enumerates @supports at-rules starting with the innermost one, going outwards."""
    layers: "NotRequired[List[CSSLayer]]"
    """Cascade layer array. Contains the layer hierarchy that this rule belongs to starting
with the innermost layer and going outwards."""
    scopes: "NotRequired[List[CSSScope]]"
    """@scope CSS at-rule array.
The array enumerates @scope at-rules starting with the innermost one, going outwards."""
    ruleTypes: "NotRequired[List[CSSRuleType]]"
    """The array keeps the types of ancestor CSSRules from the innermost going outwards."""
    startingStyles: "NotRequired[List[CSSStartingStyle]]"
    """@starting-style CSS at-rule array.
The array enumerates @starting-style at-rules starting with the innermost one, going outwards."""



CSSRuleType = Literal["MediaRule", "SupportsRule", "ContainerRule", "LayerRule", "ScopeRule", "StyleRule", "StartingStyleRule"]
"""Enum indicating the type of a CSS rule, used to represent the order of a style rule's ancestors.
This list only contains rule types that are collected during the ancestor rule collection."""



class RuleUsage(TypedDict):
    """CSS coverage information."""

    styleSheetId: "StyleSheetId"
    """The css style sheet identifier (absent for user agent stylesheet and user-specified
stylesheet rules) this rule came from."""
    startOffset: "float"
    """Offset of the start of the rule (including selector) from the beginning of the stylesheet."""
    endOffset: "float"
    """Offset of the end of the rule body from the beginning of the stylesheet."""
    used: "bool"
    """Indicates whether the rule was actually used by some element in the page."""



class SourceRange(TypedDict):
    """Text range within a resource. All numbers are zero-based."""

    startLine: "int"
    """Start line of range."""
    startColumn: "int"
    """Start column of range (inclusive)."""
    endLine: "int"
    """End line of range"""
    endColumn: "int"
    """End column of range (exclusive)."""



class ShorthandEntry(TypedDict):
    name: "str"
    """Shorthand name."""
    value: "str"
    """Shorthand value."""
    important: "NotRequired[bool]"
    """Whether the property has \"!important\" annotation (implies `false` if absent)."""



class CSSComputedStyleProperty(TypedDict):
    name: "str"
    """Computed style property name."""
    value: "str"
    """Computed style property value."""



class CSSStyle(TypedDict):
    """CSS style representation."""

    styleSheetId: "NotRequired[StyleSheetId]"
    """The css style sheet identifier (absent for user agent stylesheet and user-specified
stylesheet rules) this rule came from."""
    cssProperties: "List[CSSProperty]"
    """CSS properties in the style."""
    shorthandEntries: "List[ShorthandEntry]"
    """Computed values for all shorthands found in the style."""
    cssText: "NotRequired[str]"
    """Style declaration text (if available)."""
    range: "NotRequired[SourceRange]"
    """Style declaration range in the enclosing stylesheet (if available)."""



class CSSProperty(TypedDict):
    """CSS property declaration data."""

    name: "str"
    """The property name."""
    value: "str"
    """The property value."""
    important: "NotRequired[bool]"
    """Whether the property has \"!important\" annotation (implies `false` if absent)."""
    implicit: "NotRequired[bool]"
    """Whether the property is implicit (implies `false` if absent)."""
    text: "NotRequired[str]"
    """The full property text as specified in the style."""
    parsedOk: "NotRequired[bool]"
    """Whether the property is understood by the browser (implies `true` if absent)."""
    disabled: "NotRequired[bool]"
    """Whether the property is disabled by the user (present for source-based properties only)."""
    range: "NotRequired[SourceRange]"
    """The entire property range in the enclosing style declaration (if available)."""
    longhandProperties: "NotRequired[List[CSSProperty]]"
    """Parsed longhand components of this property if it is a shorthand.
This field will be empty if the given property is not a shorthand."""



class CSSMedia(TypedDict):
    """CSS media rule descriptor."""

    text: "str"
    """Media query text."""
    source: "str"
    """Source of the media query: \"mediaRule\" if specified by a @media rule, \"importRule\" if
specified by an @import rule, \"linkedSheet\" if specified by a \"media\" attribute in a linked
stylesheet's LINK tag, \"inlineSheet\" if specified by a \"media\" attribute in an inline
stylesheet's STYLE tag."""
    sourceURL: "NotRequired[str]"
    """URL of the document containing the media query description."""
    range: "NotRequired[SourceRange]"
    """The associated rule (@media or @import) header range in the enclosing stylesheet (if
available)."""
    styleSheetId: "NotRequired[StyleSheetId]"
    """Identifier of the stylesheet containing this object (if exists)."""
    mediaList: "NotRequired[List[MediaQuery]]"
    """Array of media queries."""



class MediaQuery(TypedDict):
    """Media query descriptor."""

    expressions: "List[MediaQueryExpression]"
    """Array of media query expressions."""
    active: "bool"
    """Whether the media query condition is satisfied."""



class MediaQueryExpression(TypedDict):
    """Media query expression descriptor."""

    value: "float"
    """Media query expression value."""
    unit: "str"
    """Media query expression units."""
    feature: "str"
    """Media query expression feature."""
    valueRange: "NotRequired[SourceRange]"
    """The associated range of the value text in the enclosing stylesheet (if available)."""
    computedLength: "NotRequired[float]"
    """Computed length of media query expression (if applicable)."""



class CSSContainerQuery(TypedDict):
    """CSS container query rule descriptor."""

    text: "str"
    """Container query text."""
    range: "NotRequired[SourceRange]"
    """The associated rule header range in the enclosing stylesheet (if
available)."""
    styleSheetId: "NotRequired[StyleSheetId]"
    """Identifier of the stylesheet containing this object (if exists)."""
    name: "NotRequired[str]"
    """Optional name for the container."""
    physicalAxes: "NotRequired[PhysicalAxes]"
    """Optional physical axes queried for the container."""
    logicalAxes: "NotRequired[LogicalAxes]"
    """Optional logical axes queried for the container."""
    queriesScrollState: "NotRequired[bool]"
    """true if the query contains scroll-state() queries."""



class CSSSupports(TypedDict):
    """CSS Supports at-rule descriptor."""

    text: "str"
    """Supports rule text."""
    active: "bool"
    """Whether the supports condition is satisfied."""
    range: "NotRequired[SourceRange]"
    """The associated rule header range in the enclosing stylesheet (if
available)."""
    styleSheetId: "NotRequired[StyleSheetId]"
    """Identifier of the stylesheet containing this object (if exists)."""



class CSSScope(TypedDict):
    """CSS Scope at-rule descriptor."""

    text: "str"
    """Scope rule text."""
    range: "NotRequired[SourceRange]"
    """The associated rule header range in the enclosing stylesheet (if
available)."""
    styleSheetId: "NotRequired[StyleSheetId]"
    """Identifier of the stylesheet containing this object (if exists)."""



class CSSLayer(TypedDict):
    """CSS Layer at-rule descriptor."""

    text: "str"
    """Layer name."""
    range: "NotRequired[SourceRange]"
    """The associated rule header range in the enclosing stylesheet (if
available)."""
    styleSheetId: "NotRequired[StyleSheetId]"
    """Identifier of the stylesheet containing this object (if exists)."""



class CSSStartingStyle(TypedDict, total=False):
    """CSS Starting Style at-rule descriptor."""

    range: "SourceRange"
    """The associated rule header range in the enclosing stylesheet (if
available)."""
    styleSheetId: "StyleSheetId"
    """Identifier of the stylesheet containing this object (if exists)."""



class CSSLayerData(TypedDict):
    """CSS Layer data."""

    name: "str"
    """Layer name."""
    subLayers: "NotRequired[List[CSSLayerData]]"
    """Direct sub-layers"""
    order: "float"
    """Layer order. The order determines the order of the layer in the cascade order.
A higher number has higher priority in the cascade order."""



class PlatformFontUsage(TypedDict):
    """Information about amount of glyphs that were rendered with given font."""

    familyName: "str"
    """Font's family name reported by platform."""
    postScriptName: "str"
    """Font's PostScript name reported by platform."""
    isCustomFont: "bool"
    """Indicates if the font was downloaded or resolved locally."""
    glyphCount: "float"
    """Amount of glyphs that were rendered with this font."""



class FontVariationAxis(TypedDict):
    """Information about font variation axes for variable fonts"""

    tag: "str"
    """The font-variation-setting tag (a.k.a. \"axis tag\")."""
    name: "str"
    """Human-readable variation name in the default language (normally, \"en\")."""
    minValue: "float"
    """The minimum value (inclusive) the font supports for this tag."""
    maxValue: "float"
    """The maximum value (inclusive) the font supports for this tag."""
    defaultValue: "float"
    """The default value."""



class FontFace(TypedDict):
    """Properties of a web font: https://www.w3.org/TR/2008/REC-CSS2-20080411/fonts.html#font-descriptions
and additional information such as platformFontFamily and fontVariationAxes."""

    fontFamily: "str"
    """The font-family."""
    fontStyle: "str"
    """The font-style."""
    fontVariant: "str"
    """The font-variant."""
    fontWeight: "str"
    """The font-weight."""
    fontStretch: "str"
    """The font-stretch."""
    fontDisplay: "str"
    """The font-display."""
    unicodeRange: "str"
    """The unicode-range."""
    src: "str"
    """The src."""
    platformFontFamily: "str"
    """The resolved platform font family"""
    fontVariationAxes: "NotRequired[List[FontVariationAxis]]"
    """Available variation settings (a.k.a. \"axes\")."""



class CSSTryRule(TypedDict):
    """CSS try rule representation."""

    styleSheetId: "NotRequired[StyleSheetId]"
    """The css style sheet identifier (absent for user agent stylesheet and user-specified
stylesheet rules) this rule came from."""
    origin: "StyleSheetOrigin"
    """Parent stylesheet's origin."""
    style: "CSSStyle"
    """Associated style declaration."""



class CSSPositionTryRule(TypedDict):
    """CSS @position-try rule representation."""

    name: "Value"
    """The prelude dashed-ident name"""
    styleSheetId: "NotRequired[StyleSheetId]"
    """The css style sheet identifier (absent for user agent stylesheet and user-specified
stylesheet rules) this rule came from."""
    origin: "StyleSheetOrigin"
    """Parent stylesheet's origin."""
    style: "CSSStyle"
    """Associated style declaration."""
    active: "bool"



class CSSKeyframesRule(TypedDict):
    """CSS keyframes rule representation."""

    animationName: "Value"
    """Animation name."""
    keyframes: "List[CSSKeyframeRule]"
    """List of keyframes."""



class CSSPropertyRegistration(TypedDict):
    """Representation of a custom property registration through CSS.registerProperty"""

    propertyName: "str"
    initialValue: "NotRequired[Value]"
    inherits: "bool"
    syntax: "str"



class CSSFontPaletteValuesRule(TypedDict):
    """CSS font-palette-values rule representation."""

    styleSheetId: "NotRequired[StyleSheetId]"
    """The css style sheet identifier (absent for user agent stylesheet and user-specified
stylesheet rules) this rule came from."""
    origin: "StyleSheetOrigin"
    """Parent stylesheet's origin."""
    fontPaletteName: "Value"
    """Associated font palette name."""
    style: "CSSStyle"
    """Associated style declaration."""



class CSSPropertyRule(TypedDict):
    """CSS property at-rule representation."""

    styleSheetId: "NotRequired[StyleSheetId]"
    """The css style sheet identifier (absent for user agent stylesheet and user-specified
stylesheet rules) this rule came from."""
    origin: "StyleSheetOrigin"
    """Parent stylesheet's origin."""
    propertyName: "Value"
    """Associated property name."""
    style: "CSSStyle"
    """Associated style declaration."""



class CSSFunctionParameter(TypedDict):
    """CSS function argument representation."""

    name: "str"
    """The parameter name."""
    type: "str"
    """The parameter type."""



class CSSFunctionConditionNode(TypedDict):
    """CSS function conditional block representation."""

    media: "NotRequired[CSSMedia]"
    """Media query for this conditional block. Only one type of condition should be set."""
    containerQueries: "NotRequired[CSSContainerQuery]"
    """Container query for this conditional block. Only one type of condition should be set."""
    supports: "NotRequired[CSSSupports]"
    """@supports CSS at-rule condition. Only one type of condition should be set."""
    children: "List[CSSFunctionNode]"
    """Block body."""
    conditionText: "str"
    """The condition text."""



class CSSFunctionNode(TypedDict, total=False):
    """Section of the body of a CSS function rule."""

    condition: "CSSFunctionConditionNode"
    """A conditional block. If set, style should not be set."""
    style: "CSSStyle"
    """Values set by this node. If set, condition should not be set."""



class CSSFunctionRule(TypedDict):
    """CSS function at-rule representation."""

    name: "Value"
    """Name of the function."""
    styleSheetId: "NotRequired[StyleSheetId]"
    """The css style sheet identifier (absent for user agent stylesheet and user-specified
stylesheet rules) this rule came from."""
    origin: "StyleSheetOrigin"
    """Parent stylesheet's origin."""
    parameters: "List[CSSFunctionParameter]"
    """List of parameters."""
    children: "List[CSSFunctionNode]"
    """Function body."""



class CSSKeyframeRule(TypedDict):
    """CSS keyframe rule representation."""

    styleSheetId: "NotRequired[StyleSheetId]"
    """The css style sheet identifier (absent for user agent stylesheet and user-specified
stylesheet rules) this rule came from."""
    origin: "StyleSheetOrigin"
    """Parent stylesheet's origin."""
    keyText: "Value"
    """Associated key text."""
    style: "CSSStyle"
    """Associated style declaration."""



class StyleDeclarationEdit(TypedDict):
    """A descriptor of operation to mutate style declaration text."""

    styleSheetId: "StyleSheetId"
    """The css style sheet identifier."""
    range: "SourceRange"
    """The range of the style text in the enclosing stylesheet."""
    text: "str"
    """New style text."""
