# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP CacheStorage Domain Types"""

from typing import List
from typing_extensions import Literal
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..storage.types import StorageBucket

CacheId = str
"""Unique identifier of the Cache object."""



CachedResponseType = Literal["basic", "cors", "default", "error", "opaqueResponse", "opaqueRedirect"]
"""type of HTTP response cached"""



class DataEntry(TypedDict):
    """Data entry."""

    requestURL: "str"
    """Request URL."""
    requestMethod: "str"
    """Request method."""
    requestHeaders: "List[Header]"
    """Request headers"""
    responseTime: "float"
    """Number of seconds since epoch."""
    responseStatus: "int"
    """HTTP response status code."""
    responseStatusText: "str"
    """HTTP response status text."""
    responseType: "CachedResponseType"
    """HTTP response type"""
    responseHeaders: "List[Header]"
    """Response headers"""



class Cache(TypedDict):
    """Cache identifier."""

    cacheId: "CacheId"
    """An opaque unique id of the cache."""
    securityOrigin: "str"
    """Security origin of the cache."""
    storageKey: "str"
    """Storage key of the cache."""
    storageBucket: "NotRequired[StorageBucket]"
    """Storage bucket of the cache."""
    cacheName: "str"
    """The name of the cache."""



class Header(TypedDict):
    name: "str"
    value: "str"



class CachedResponse(TypedDict):
    """Cached response"""

    body: "str"
    """Entry content, base64-encoded. (Encoded as a base64 string when passed over JSON)"""
