# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP CacheStorage Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import DeleteCacheParameters
    from .commands import DeleteEntryParameters
    from .commands import RequestCacheNamesParameters
    from .commands import RequestCacheNamesReturns
    from .commands import RequestCachedResponseParameters
    from .commands import RequestCachedResponseReturns
    from .commands import RequestEntriesParameters
    from .commands import RequestEntriesReturns

class CacheStorageClient:
    """Client for CacheStorage domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def deleteCache(
        self,
        params: "DeleteCacheParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Deletes a cache."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="CacheStorage.deleteCache",
            params=params,
            session_id=session_id,
        ))

    async def deleteEntry(
        self,
        params: "DeleteEntryParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Deletes a cache entry."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="CacheStorage.deleteEntry",
            params=params,
            session_id=session_id,
        ))

    async def requestCacheNames(
        self,
        params: Optional["RequestCacheNamesParameters"] = None,
        session_id: Optional[str] = None,
    ) -> "RequestCacheNamesReturns":
        """Requests cache names."""
        return cast("RequestCacheNamesReturns", await self._client.send_raw(
            method="CacheStorage.requestCacheNames",
            params=params,
            session_id=session_id,
        ))

    async def requestCachedResponse(
        self,
        params: "RequestCachedResponseParameters",
        session_id: Optional[str] = None,
    ) -> "RequestCachedResponseReturns":
        """Fetches cache entry."""
        return cast("RequestCachedResponseReturns", await self._client.send_raw(
            method="CacheStorage.requestCachedResponse",
            params=params,
            session_id=session_id,
        ))

    async def requestEntries(
        self,
        params: "RequestEntriesParameters",
        session_id: Optional[str] = None,
    ) -> "RequestEntriesReturns":
        """Requests data from cache."""
        return cast("RequestEntriesReturns", await self._client.send_raw(
            method="CacheStorage.requestEntries",
            params=params,
            session_id=session_id,
        ))


