# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP BluetoothEmulation Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import AddCharacteristicParameters
    from .commands import AddCharacteristicReturns
    from .commands import AddDescriptorParameters
    from .commands import AddDescriptorReturns
    from .commands import AddServiceParameters
    from .commands import AddServiceReturns
    from .commands import EnableParameters
    from .commands import RemoveCharacteristicParameters
    from .commands import RemoveDescriptorParameters
    from .commands import RemoveServiceParameters
    from .commands import SetSimulatedCentralStateParameters
    from .commands import SimulateAdvertisementParameters
    from .commands import SimulateCharacteristicOperationResponseParameters
    from .commands import SimulateDescriptorOperationResponseParameters
    from .commands import SimulateGATTDisconnectionParameters
    from .commands import SimulateGATTOperationResponseParameters
    from .commands import SimulatePreconnectedPeripheralParameters

class BluetoothEmulationClient:
    """Client for BluetoothEmulation domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def enable(
        self,
        params: "EnableParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enable the BluetoothEmulation domain."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BluetoothEmulation.enable",
            params=params,
            session_id=session_id,
        ))

    async def setSimulatedCentralState(
        self,
        params: "SetSimulatedCentralStateParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Set the state of the simulated central."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BluetoothEmulation.setSimulatedCentralState",
            params=params,
            session_id=session_id,
        ))

    async def disable(
        self,
        params: None = None,
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disable the BluetoothEmulation domain."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BluetoothEmulation.disable",
            params=params,
            session_id=session_id,
        ))

    async def simulatePreconnectedPeripheral(
        self,
        params: "SimulatePreconnectedPeripheralParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Simulates a peripheral with |address|, |name| and |knownServiceUuids|
that has already been connected to the system."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BluetoothEmulation.simulatePreconnectedPeripheral",
            params=params,
            session_id=session_id,
        ))

    async def simulateAdvertisement(
        self,
        params: "SimulateAdvertisementParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Simulates an advertisement packet described in |entry| being received by
the central."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BluetoothEmulation.simulateAdvertisement",
            params=params,
            session_id=session_id,
        ))

    async def simulateGATTOperationResponse(
        self,
        params: "SimulateGATTOperationResponseParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Simulates the response code from the peripheral with |address| for a
GATT operation of |type|. The |code| value follows the HCI Error Codes from
Bluetooth Core Specification Vol 2 Part D 1.3 List Of Error Codes."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BluetoothEmulation.simulateGATTOperationResponse",
            params=params,
            session_id=session_id,
        ))

    async def simulateCharacteristicOperationResponse(
        self,
        params: "SimulateCharacteristicOperationResponseParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Simulates the response from the characteristic with |characteristicId| for a
characteristic operation of |type|. The |code| value follows the Error
Codes from Bluetooth Core Specification Vol 3 Part F 3.4.1.1 Error Response.
The |data| is expected to exist when simulating a successful read operation
response."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BluetoothEmulation.simulateCharacteristicOperationResponse",
            params=params,
            session_id=session_id,
        ))

    async def simulateDescriptorOperationResponse(
        self,
        params: "SimulateDescriptorOperationResponseParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Simulates the response from the descriptor with |descriptorId| for a
descriptor operation of |type|. The |code| value follows the Error
Codes from Bluetooth Core Specification Vol 3 Part F 3.4.1.1 Error Response.
The |data| is expected to exist when simulating a successful read operation
response."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BluetoothEmulation.simulateDescriptorOperationResponse",
            params=params,
            session_id=session_id,
        ))

    async def addService(
        self,
        params: "AddServiceParameters",
        session_id: Optional[str] = None,
    ) -> "AddServiceReturns":
        """Adds a service with |serviceUuid| to the peripheral with |address|."""
        return cast("AddServiceReturns", await self._client.send_raw(
            method="BluetoothEmulation.addService",
            params=params,
            session_id=session_id,
        ))

    async def removeService(
        self,
        params: "RemoveServiceParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Removes the service respresented by |serviceId| from the simulated central."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BluetoothEmulation.removeService",
            params=params,
            session_id=session_id,
        ))

    async def addCharacteristic(
        self,
        params: "AddCharacteristicParameters",
        session_id: Optional[str] = None,
    ) -> "AddCharacteristicReturns":
        """Adds a characteristic with |characteristicUuid| and |properties| to the
service represented by |serviceId|."""
        return cast("AddCharacteristicReturns", await self._client.send_raw(
            method="BluetoothEmulation.addCharacteristic",
            params=params,
            session_id=session_id,
        ))

    async def removeCharacteristic(
        self,
        params: "RemoveCharacteristicParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Removes the characteristic respresented by |characteristicId| from the
simulated central."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BluetoothEmulation.removeCharacteristic",
            params=params,
            session_id=session_id,
        ))

    async def addDescriptor(
        self,
        params: "AddDescriptorParameters",
        session_id: Optional[str] = None,
    ) -> "AddDescriptorReturns":
        """Adds a descriptor with |descriptorUuid| to the characteristic respresented
by |characteristicId|."""
        return cast("AddDescriptorReturns", await self._client.send_raw(
            method="BluetoothEmulation.addDescriptor",
            params=params,
            session_id=session_id,
        ))

    async def removeDescriptor(
        self,
        params: "RemoveDescriptorParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Removes the descriptor with |descriptorId| from the simulated central."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BluetoothEmulation.removeDescriptor",
            params=params,
            session_id=session_id,
        ))

    async def simulateGATTDisconnection(
        self,
        params: "SimulateGATTDisconnectionParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Simulates a GATT disconnection from the peripheral with |address|."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BluetoothEmulation.simulateGATTDisconnection",
            params=params,
            session_id=session_id,
        ))


