# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP BluetoothEmulation Domain Commands"""

from typing import List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from .types import CentralState
    from .types import CharacteristicOperationType
    from .types import CharacteristicProperties
    from .types import DescriptorOperationType
    from .types import GATTOperationType
    from .types import ManufacturerData
    from .types import ScanEntry

class EnableParameters(TypedDict):
    state: "CentralState"
    """State of the simulated central."""
    leSupported: "bool"
    """If the simulated central supports low-energy."""





class SetSimulatedCentralStateParameters(TypedDict):
    state: "CentralState"
    """State of the simulated central."""





class SimulatePreconnectedPeripheralParameters(TypedDict):
    address: "str"
    name: "str"
    manufacturerData: "List[ManufacturerData]"
    knownServiceUuids: "List[str]"





class SimulateAdvertisementParameters(TypedDict):
    entry: "ScanEntry"





class SimulateGATTOperationResponseParameters(TypedDict):
    address: "str"
    type: "GATTOperationType"
    code: "int"





class SimulateCharacteristicOperationResponseParameters(TypedDict):
    characteristicId: "str"
    type: "CharacteristicOperationType"
    code: "int"
    data: "NotRequired[str]"





class SimulateDescriptorOperationResponseParameters(TypedDict):
    descriptorId: "str"
    type: "DescriptorOperationType"
    code: "int"
    data: "NotRequired[str]"





class AddServiceParameters(TypedDict):
    address: "str"
    serviceUuid: "str"


class AddServiceReturns(TypedDict):
    serviceId: "str"
    """An identifier that uniquely represents this service."""



class RemoveServiceParameters(TypedDict):
    serviceId: "str"





class AddCharacteristicParameters(TypedDict):
    serviceId: "str"
    characteristicUuid: "str"
    properties: "CharacteristicProperties"


class AddCharacteristicReturns(TypedDict):
    characteristicId: "str"
    """An identifier that uniquely represents this characteristic."""



class RemoveCharacteristicParameters(TypedDict):
    characteristicId: "str"





class AddDescriptorParameters(TypedDict):
    characteristicId: "str"
    descriptorUuid: "str"


class AddDescriptorReturns(TypedDict):
    descriptorId: "str"
    """An identifier that uniquely represents this descriptor."""



class RemoveDescriptorParameters(TypedDict):
    descriptorId: "str"





class SimulateGATTDisconnectionParameters(TypedDict):
    address: "str"


