# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP BackgroundService Domain Library"""

from typing import Any, Dict, Optional, cast

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ...client import CDPClient
    from .commands import ClearEventsParameters
    from .commands import SetRecordingParameters
    from .commands import StartObservingParameters
    from .commands import StopObservingParameters

class BackgroundServiceClient:
    """Client for BackgroundService domain commands."""

    def __init__(self, client: 'CDPClient'):
        self._client = client

    async def startObserving(
        self,
        params: "StartObservingParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Enables event updates for the service."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BackgroundService.startObserving",
            params=params,
            session_id=session_id,
        ))

    async def stopObserving(
        self,
        params: "StopObservingParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Disables event updates for the service."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BackgroundService.stopObserving",
            params=params,
            session_id=session_id,
        ))

    async def setRecording(
        self,
        params: "SetRecordingParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Set the recording state for the service."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BackgroundService.setRecording",
            params=params,
            session_id=session_id,
        ))

    async def clearEvents(
        self,
        params: "ClearEventsParameters",
        session_id: Optional[str] = None,
    ) -> "Dict[str, Any]":
        """Clears all stored data for the service."""
        return cast("Dict[str, Any]", await self._client.send_raw(
            method="BackgroundService.clearEvents",
            params=params,
            session_id=session_id,
        ))


