# This file is auto-generated by the CDP protocol generator.
# Do not edit this file manually as your changes will be overwritten.
# Generated from Chrome DevTools Protocol specifications.

"""CDP Accessibility Domain Commands"""

from typing import List
from typing_extensions import NotRequired, TypedDict

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from ..dom.types import BackendNodeId
    from ..dom.types import NodeId
    from ..page.types import FrameId
    from ..runtime.types import RemoteObjectId
    from .types import AXNode
    from .types import AXNodeId

class GetPartialAXTreeParameters(TypedDict, total=False):
    nodeId: "NodeId"
    """Identifier of the node to get the partial accessibility tree for."""
    backendNodeId: "BackendNodeId"
    """Identifier of the backend node to get the partial accessibility tree for."""
    objectId: "RemoteObjectId"
    """JavaScript object id of the node wrapper to get the partial accessibility tree for."""
    fetchRelatives: "bool"
    """Whether to fetch this node's ancestors, siblings and children. Defaults to true."""


class GetPartialAXTreeReturns(TypedDict):
    nodes: "List[AXNode]"
    """The `Accessibility.AXNode` for this DOM node, if it exists, plus its ancestors, siblings and
children, if requested."""



class GetFullAXTreeParameters(TypedDict, total=False):
    depth: "int"
    """The maximum depth at which descendants of the root node should be retrieved.
If omitted, the full tree is returned."""
    frameId: "FrameId"
    """The frame for whose document the AX tree should be retrieved.
If omitted, the root frame is used."""


class GetFullAXTreeReturns(TypedDict):
    nodes: "List[AXNode]"



class GetRootAXNodeParameters(TypedDict, total=False):
    frameId: "FrameId"
    """The frame in whose document the node resides.
If omitted, the root frame is used."""


class GetRootAXNodeReturns(TypedDict):
    node: "AXNode"



class GetAXNodeAndAncestorsParameters(TypedDict, total=False):
    nodeId: "NodeId"
    """Identifier of the node to get."""
    backendNodeId: "BackendNodeId"
    """Identifier of the backend node to get."""
    objectId: "RemoteObjectId"
    """JavaScript object id of the node wrapper to get."""


class GetAXNodeAndAncestorsReturns(TypedDict):
    nodes: "List[AXNode]"



class GetChildAXNodesParameters(TypedDict):
    id: "AXNodeId"
    frameId: "NotRequired[FrameId]"
    """The frame in whose document the node resides.
If omitted, the root frame is used."""


class GetChildAXNodesReturns(TypedDict):
    nodes: "List[AXNode]"



class QueryAXTreeParameters(TypedDict, total=False):
    nodeId: "NodeId"
    """Identifier of the node for the root to query."""
    backendNodeId: "BackendNodeId"
    """Identifier of the backend node for the root to query."""
    objectId: "RemoteObjectId"
    """JavaScript object id of the node wrapper for the root to query."""
    accessibleName: "str"
    """Find nodes with this computed name."""
    role: "str"
    """Find nodes with this computed role."""


class QueryAXTreeReturns(TypedDict):
    nodes: "List[AXNode]"
    """A list of `Accessibility.AXNode` matching the specified attributes,
including nodes that are ignored for accessibility."""
