# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class Section(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        Section - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'field_list': 'list[FieldList]',
            'instruction_text': 'str',
            'key': 'str',
            'state': 'str'
        }

        self.attribute_map = {
            'field_list': 'fieldList',
            'instruction_text': 'instructionText',
            'key': 'key',
            'state': 'state'
        }

        self._field_list = None
        self._instruction_text = None
        self._key = None
        self._state = None

    @property
    def field_list(self):
        """
        Gets the field_list of this Section.


        :return: The field_list of this Section.
        :rtype: list[FieldList]
        """
        return self._field_list

    @field_list.setter
    def field_list(self, field_list):
        """
        Sets the field_list of this Section.


        :param field_list: The field_list of this Section.
        :type: list[FieldList]
        """
        

        self._field_list = field_list

    @property
    def instruction_text(self):
        """
        Gets the instruction_text of this Section.


        :return: The instruction_text of this Section.
        :rtype: str
        """
        return self._instruction_text

    @instruction_text.setter
    def instruction_text(self, instruction_text):
        """
        Sets the instruction_text of this Section.


        :param instruction_text: The instruction_text of this Section.
        :type: str
        """
        

        self._instruction_text = instruction_text

    @property
    def key(self):
        """
        Gets the key of this Section.


        :return: The key of this Section.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this Section.


        :param key: The key of this Section.
        :type: str
        """
        

        self._key = key

    @property
    def state(self):
        """
        Gets the state of this Section.


        :return: The state of this Section.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this Section.


        :param state: The state of this Section.
        :type: str
        """
        

        self._state = state

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

