#!/usr/bin/env python
# coding: utf-8

# In[1]:


import set_working_directory


# In[2]:


from cogent3 import load_aligned_seqs, make_aligned_seqs, make_seq

s1 = make_seq("TGATGTAAGGTAGTT", name="s1", moltype="dna")
s2 = make_seq("--CTGGAAGGGT---", name="s2", moltype="dna")

seqs = make_aligned_seqs(data=[s1, s2], array_align=False, moltype="dna")
draw = seqs.information_plot(window=2, include_gap=True)
draw.show(width=500, height=400)


# In[3]:


aln = load_aligned_seqs("data/brca1.fasta", moltype="protein")

fig = aln.information_plot(stat="median")
fig.show(width=500, height=400)


# In[4]:


outpath = set_working_directory.get_thumbnail_dir() / "plot_aln-info-plot.png"

fig.write(outpath)

