# pylook

Data analysis tools for rock mechanics experiments in the spirit of the legacy XLook tool.

We follow the [semantic versioning](https://semver.org/) practice. That means that while the
package is 0.X (as it is currently) we may be changing the API as design constraints and
decisions are reached. We won't break your code for fun, but we also won't burden users for
the next decade to maintain a bad design decision that was made. When you see a version
number like 0.a.b it means that a is a feature release and b is a bug fix only release.

We only support Python 3 and you should too! It's not hard to switch from Python 2, has
massive performance improvements, and is regularly updated.

## Contributing
**Imposter syndrome disclaimer**: We want your help. No, really.

There may be a little voice inside your head that is telling you that you're not ready to be
an open source contributor; that your skills aren't nearly good enough to contribute. What
could you possibly offer a project like this one?

We assure you - the little voice in your head is wrong. If you can write code at all,
you can contribute code to open source. Contributing to open source projects is a fantastic
way to advance one's coding skills. Writing perfect code isn't the measure of a good developer
(that would disqualify all of us!); it's trying to create something, making mistakes, and
learning from those mistakes. That's how we all improve, and we are happy to help others learn.

Being an open source contributor doesn't just mean writing code, either. You can help out by
writing documentation, tests, or even giving feedback about the project (and yes - that
includes giving feedback about the contribution process). Some of these contributions may be
the most valuable to the project as a whole, because you're coming to the project with fresh
eyes, so you can see the errors and assumptions that seasoned contributors have glossed over.

For more information, please read the see the [contributing guide](https://github.com/leemangeophysicalllc/pylook/blob/master/CONTRIBUTING.md).

## Philosophy
Data processing should have an audit trail - what did you do to the raw data to get to where
you are when the data are published? This not only helps find and eliminate and errors, but
also allows others in the future to reprocess the data with new techniques or query the raw
data for some other purpose that you may never have thought of! If we only archive our
processed data and do not document what happened to it - that utility is gone. It is your
reponsibility as a researcher, likely funded by public funds, to make that data yeild every
ounce of useful information it can. That includes making it useful for others in the future!

PyLook is growing to replace the tool "XLook" developed by Chris Marone and others as the
primary tool for processing data from the experimental rock mechanics field. XLook is a very
fast and versatile tool that had its own syntax for performing math and other operations. It
can work with the proprietary binary format common to several labs as well as simple ASCII
text. Python allows us to leverage modern tools and signal processing libraries as well as
seamlessly pass data to data science tools.

What about your legacy files? Don't worry, your "r files" (short for reduction files) will
still work. You can still run the old experiments in the modern tools, but with the idea that
new experiments can be reduced in pure Python. We have provided examples of both!

## What Can't PyLook Do
Quite a bit actually. We've got the basics for simple double direct shear experiments and a
few other functions, but there is plenty to do. We need to implement the rest of the XLook
syntax commands and continue to add more functionality! Rate and state inversion is also
high on the list.

## Thank You
A big thank you to Unidata's Python team for much of the excellent contributing and README
text templates and for their efforts to maintain the scientific Python stack. All projects
benefit from standing on the shoulders of these and the many other tireless volunteers and
supportive companies.
