import { MainAreaWidget } from '@jupyterlab/apputils';
import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import { ISettingRegistry } from '@jupyterlab/settingregistry';
import { Panel } from '@lumino/widgets';
import { IDiffOptions, IFileDiff, IThread } from '../../tokens';
/**
 * FileDiffWidget properties
 */
export interface IFileDiffWidgetProps {
    /**
     * Filename
     */
    filename: string;
    /**
     * Pull request ID
     */
    pullRequestId: string;
    /**
     * Rendermime registry
     */
    renderMime: IRenderMimeRegistry;
    /**
     * Settings registry
     */
    settingsRegistry: ISettingRegistry | null;
}
/**
 * FileDiffWidget
 */
export declare class FileDiffWidget extends MainAreaWidget<Panel> {
    constructor(props: IFileDiffWidgetProps);
    /**
     * Load the file diff and the associated discussions
     *
     * @param pullRequestId Pull request Id
     * @param filename Filename
     */
    protected static loadDiff(pullRequestId: string, filename: string): Promise<[IFileDiff, IThread[]]>;
    /**
     * Display the diff widget depending of the file type
     *
     * @param diffProps Diff properties
     */
    protected showDiff(diffProps: IDiffOptions): void;
    /**
     * Display an error message
     *
     * @param message Error message
     */
    protected showError(message: string): void;
}
