import { Widget } from '@lumino/widgets';
import CodeMirror from 'codemirror';
import 'codemirror/addon/display/placeholder.js';
/**
 * InputComment widget properties
 */
export interface IInputCommentProps {
    /**
     * Callback to comment submission
     */
    handleSubmit: (comment: string) => void;
    /**
     * Callback to comment cancellation
     */
    handleCancel: () => void;
}
/**
 * InputComment widget
 */
export declare class InputComment extends Widget {
    constructor(props: IInputCommentProps);
    /**
     * Comment
     */
    get comment(): string;
    set comment(v: string);
    /**
     * Handle click event on cancel button
     *
     * @param event Click event
     */
    protected handleCancel(event: Event): void;
    /**
     * Handle comment input event
     *
     * @param event Input event
     */
    protected handleInputChange(editor: CodeMirror.Editor): void;
    /**
     * Handle click event on add comment button
     *
     * @param event Click event
     */
    protected handleSubmit(event: Event): void;
    /**
     * Initialize the widget HTML node
     */
    protected initNode(): void;
    private _handleRemove;
    private _handleSubmit;
    private _comment;
}
